@extends('dashboard.layouts.app')
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Create Unit Type</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="{{ route('mall-software.unit_type_management.index') }}" class="breadcrumb">Unit Types</a>
                <a href="#" class="breadcrumb">Create Unit Type</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>

                        <form method="post" action="{{ route('mall-software.unit_type_management.store') }}"
                            class="formValidate" id="formValidate" name="formValidate" data-parsely-validate="">
                            @csrf

                            <div class="row">
                                <div class="input-field col s6 m3">
                                    <input id="type" type="text" name="type" value="{{ old('type') }}"
                                        required>
                                    <label for="type" class="active" style="color: red">Type<span
                                            class="red-star">*</span></label>
                                    @error('type')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="input-field col s6 m3">
                                    <input id="area" type="text" name="area" value="{{ old('area') }}" required
                                        data-parsley-type="number">
                                    <label for="area" class="active" style="color: red">Area<span
                                            class="red-star">*</span></label>
                                    @error('area')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <input type="submit" class="btn" value="Save">
                                    <a href="{{ route('mall-software.unit_type_management.index') }}"
                                        class="btn">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#formValidate').parsley();
        });
    </script>
@endsection
