@extends('dashboard.layouts.app')
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Unit Type Management</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="#" class="breadcrumb">Unit Types</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="d-flex align-items-center">
                            <h5 class="card-title activator"><a class="waves-effect waves-light btn m-t-10"
                                    href="{{ route('mall-software.unit_type_management.create') }}">Create Unit Type</a></h5>
                        </div>
                        <div class="success-alert-bar p-15 m-b-20 green white-text" id="outletdeleteMsg"
                            style="display: none">
                            Outlet Successfully Deleted
                        </div>

                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif

                        <div class="row">
                            <table id="units_table" class="responsive-table display" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Type</th>
                                        <th>Area</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        //get all data to table
        $(function() {
            $('#units_table').DataTable({
                retrieve: true,
                processing: true,
                serverSide: true,
                sScrollX: false,
                ajax: '{{ route('mall-software.unit_type_management.list') }}',
                scrollX: true,
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'type',
                    },
                    {
                        data: 'area',
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                    },
                ]
            });
        });
    </script>
@endsection
