<?php

use Illuminate\Support\Facades\Route;

/*







|--------------------------------------------------------------------------







| Web Routes







|--------------------------------------------------------------------------







|







| Here is where you can register web routes for your application. These







| routes are loaded by the RouteServiceProvider within a group which







| contains the "web" middleware group. Now create something great!







|







*/

Route::get('/clear-all-cache', function () {
    Artisan::call('cache:clear');

    Artisan::call('route:clear');

    Artisan::call('view:clear');

    Artisan::call('config:clear');

    echo 'Cleared all caches successfully.';
});

Auth::routes();

Route::get('/register', 'Dashboard\DashboardController@index')->name('home'); // to prevent registration without login //18-11-2022

Route::get('/', 'Dashboard\DashboardController@index')->name('home');

// Route::get('/home', 'Dashboard\DashboardController@index')->name('home');

Route::get('/logout', 'Dashboard\DashboardController@logout')->name('dashboard.logout');

Route::group(['prefix' => 'dashboard', 'middleware' => 'checkstatus'], function () {
    Route::get('/', 'Dashboard\DashboardController@index')->name('dashboard.home')->middleware(['permission:leads']);
    Route::get('/add-new-staffs', 'Dashboard\DashboardController@addnewStaffs');
    Route::get('/logout', 'Dashboard\DashboardController@logout')->name('dashboard.logout');
    Route::get('/change-password', 'Dashboard\ChangePasswordController@index')->name('changePassword');
    Route::post('/change-password/update', 'Dashboard\ChangePasswordController@update')->name('updatePassword');
    Route::get('/profile', 'Dashboard\UserController@profile')->name('user.profile');
    Route::post('/profile/update', 'Dashboard\UserController@updateProfile')->name('user.updateProfile');
    Route::post('/profile/change-password', 'Dashboard\UserController@changePassword')->name('user.changePassword');

    Route::group(['prefix' => 'users'], function () {
        Route::get('/', 'Dashboard\UserController@index')->name('user.index')->middleware(['permission:create-user']);
        Route::get('/create', 'Dashboard\UserController@create')->name('user.create')->middleware(['permission:create-user']);
        Route::post('/store', 'Dashboard\UserController@store')->name('user.store')->middleware(['permission:create-user']);
        Route::get('/edit/{id}', 'Dashboard\UserController@edit')->name('user.edit')->middleware(['permission:edit-user']);
        Route::post('/update', 'Dashboard\UserController@update')->name('user.update')->middleware(['permission:edit-user']);
    });

    Route::group(['prefix' => 'leads'], function () {
        Route::post('/approve-duplicate-entry', 'Dashboard\AjaxController@approveDuplicateEntry')->name('lead.approve')->middleware(['permission:listing-lead']);
        Route::post('/approve-lost-lead', 'Dashboard\AjaxController@approveLostLead')->name('lead.lostapprove')->middleware(['permission:listing-lead']);
        Route::post('/get-preferred-projects', 'Dashboard\AjaxController@getPreferredProjects');
        Route::delete('/delete', 'Dashboard\AjaxController@deleteLead')->middleware(['permission:delete-lead']);
        Route::delete('/delete-lead', 'Dashboard\AjaxController@leadDelete')->middleware(['permission:delete-lead']);
        Route::post('/get-remarks', 'Dashboard\AjaxController@getRemarks')->name('lead.remarks')->middleware(['permission:sales-person-actions']);
        Route::post('/get-lead-edit-view', 'Dashboard\AjaxController@getLeadEditView')->name('lead.editView')->middleware(['permission:sales-person-actions']);
        Route::post('/edit-salesperson-action', 'Dashboard\AjaxController@editSalesPersonAction')->name('lead.editSales')->middleware(['permission:sales-person-actions']);
        Route::delete('/tasks/delete', 'Dashboard\AjaxController@deleteTask');
        Route::post('/tasks/get-task-edit-status-view', 'Dashboard\AjaxController@getTaskEditStatusView')->name('task.taskstatus')->middleware(['permission:listing-lead']);
        Route::post('/tasks/update-task-status', 'Dashboard\AjaxController@updateTaskStatus')->name('task.updatetaskstatus')->middleware(['permission:listing-lead']);
        Route::post('/tasks/update-task-completed-status', 'Dashboard\AjaxController@updateTaskCompletedStatus')->name('task.updateTaskCompletedStatus')->middleware(['permission:listing-lead']);
        Route::delete('/notes/delete', 'Dashboard\AjaxController@deleteNote');
        Route::post('/get-project-blocks', 'Dashboard\AjaxController@getProjectBlocks');
        Route::post('/get-project-units', 'Dashboard\AjaxController@getProjectUnits');
        Route::delete('/sales-activity/delete', 'Dashboard\AjaxController@deletesalesActivity');
        Route::post('/get-duplicate-leads', 'Dashboard\AjaxController@getDuplicateLeads')->name('lead.duplicate')->middleware(['permission:listing-lead']); // by mobile
        Route::post('/get-duplicate-bank-leads', 'Dashboard\AjaxController@getDuplicateBankLeads')->name('lead.duplicate.bank')->middleware(['permission:listing-lead']); // by leadbank mobile
        Route::post('/get-duplicate-leads-maker', 'Dashboard\AjaxController@getDuplicateLeadsMaker')->name('lead.duplicate-maker')->middleware(['permission:listing-lead']); // by ;mobile
        Route::post('/get-duplicate-leads-by-email', 'Dashboard\AjaxController@getDuplicateLeadsEmail')->name('lead.duplicateEmail')->middleware(['permission:listing-lead']); // by email
        Route::post('/get-duplicate-leads-bank-by-email', 'Dashboard\AjaxController@getDuplicateLeadsBankEmail')->name('lead.duplicateBankEmail')->middleware(['permission:listing-lead']); // by LeadBankemail
        Route::post('/get-duplicate-leads-by-email-maker', 'Dashboard\AjaxController@getDuplicateLeadsEmailMaker')->name('lead.duplicateEmailMaker')->middleware(['permission:listing-lead']); // by email
        Route::post('/get-salesperson-by-lead-email', 'Dashboard\AjaxController@getSalespersonByEmail');
        Route::post('/duplicate-email-check', 'Dashboard\AjaxController@duplicateEmailCheck');
        Route::post('/duplicate-mobile-check', 'Dashboard\AjaxController@duplicateMobileCheck');
        Route::post('/get-salesperson-by-lead-mobile', 'Dashboard\AjaxController@getSalespersonByMobile');
    });

    Route::group(['prefix' => 'roles'], function () {
        Route::get('/', 'Dashboard\RoleController@index')->name('role.index')->middleware(['permission:listing-role']);
        Route::get('/create', 'Dashboard\RoleController@create')->name('role.create')->middleware(['permission:create-role']);
        Route::post('/store', 'Dashboard\RoleController@store')->name('role.store')->middleware(['permission:create-role']);
        Route::get('/edit/{id}', 'Dashboard\RoleController@edit')->name('role.edit')->middleware(['permission:edit-role']);
        Route::post('/update', 'Dashboard\RoleController@update')->name('role.update')->middleware(['permission:edit-role']);
    });
    Route::group(['prefix' => 'registration-form'], function () {
        Route::get('/', 'Dashboard\RegistrationForm\RegistrationFormController@index')->name('registration.form.index')->middleware(['permission:project-registration-form']);
        Route::get('/list', 'Dashboard\RegistrationForm\RegistrationFormController@list')->name('registration.form.list')->middleware(['permission:project-registration-form']);
        Route::get('/create/{preferred_project}', 'Dashboard\RegistrationForm\RegistrationFormController@create')->name('registration.form.create')->middleware(['permission:project-registration-form']);
        Route::post('/store', 'Dashboard\RegistrationForm\RegistrationFormController@store')->name('registration.form.store')->middleware(['permission:project-registration-form']);
        Route::post('/units', 'Dashboard\RegistrationForm\RegistrationFormController@units')->name('registration.project.units')->middleware(['permission:project-registration-form']);
        Route::post('/download', 'Dashboard\RegistrationForm\RegistrationFormController@download')->name('registration.project.form.download')->middleware(['permission:project-registration-form']);
        Route::get('/client-download/{id}', 'Dashboard\RegistrationForm\RegistrationFormController@clientDownload')->name('registration.client.form.download')->middleware(['permission:project-registration-form']);
    });

    Route::group(['prefix' => 'project-units'], function () {
        Route::delete('/delete', 'Dashboard\AjaxController@deleteProjectBlock');
    });

    Route::group(['prefix' => 'performance'], function () {
        Route::post('/update', 'Dashboard\AjaxController@updatePerformance')->name('performance.update')->middleware(['permission:performance-management']);
    });

    Route::group(['prefix' => 'activity-logs'], function () {
        Route::get('/', 'Dashboard\ActivityLogController@index')->name('activity.index')->middleware(['permission:activity-logs']);
        Route::get('/list', 'Dashboard\ActivityLogController@list')->name('activity.list')->middleware(['permission:activity-logs']);
        Route::get('last-activity', 'Dashboard\ActivityLogController@lastActivity')->name('activity.last')->middleware(['permission:last-activity-logs']);
        Route::get('/last-activity-list', 'Dashboard\ActivityLogController@lastActivityList')->name('activity.lastlist')->middleware(['permission:last-activity-logs']);
    });


    Route::post('/get-preferred-projects', 'Dashboard\AjaxController@getPreferredProjects');
    Route::delete('/delete', 'Dashboard\AjaxController@deleteLead')->middleware(['permission:delete-lead']);

    // Route::delete('/tasks/delete', 'CRM\AjaxController@deleteTask');

    Route::post('/tasks/get-task-edit-status-view', 'Dashboard\AjaxController@getTaskEditStatusView')->name('task.taskstatus')->middleware(['permission:listing-lead']);
    Route::post('/tasks/update-task-status', 'Dashboard\AjaxController@updateTaskStatus')->name('task.updatetaskstatus')->middleware(['permission:listing-lead']);
    Route::post('/get-project-blocks', 'Dashboard\AjaxController@getProjectBlocks');
    Route::post('/get-project-units', 'Dashboard\AjaxController@getProjectUnits');
    Route::post('/get-duplicate-leads', 'Dashboard\AjaxController@getDuplicateLeads')->name('lead.duplicate')->middleware(['permission:listing-lead']); // by mobile
    Route::post('/get-duplicate-leads-by-email', 'Dashboard\AjaxController@getDuplicateLeadsEmail')->name('lead.duplicateEmail')->middleware(['permission:listing-lead']); // by email
    Route::post('/get-salesperson-by-lead-email', 'Dashboard\AjaxController@getSalespersonByEmail');
    Route::post('/get-salesperson-by-lead-mobile', 'Dashboard\AjaxController@getSalespersonByMobile');

    // MALL-SOFTWARE

    //Rate Item Definition
    Route::get('/rate-item-definition', 'MallSoftware\RateItemDefinitionController@index')->name('mall-software.rate_item_definition');
    Route::get('/rate-item-definition-list', 'MallSoftware\RateItemDefinitionController@list')->name('mall-software.rate_item_definition.list');
    Route::get('/rate-item-definition-create', 'MallSoftware\RateItemDefinitionController@create')->name('mall-software.rate_item_definition.create');
    Route::get('/rate-item-definition-get-ledgers', 'MallSoftware\RateItemDefinitionController@getLedgers')->name('mall-software.rate_item_definition.getLedgers');
    Route::post('/rate-item-definition-store', 'MallSoftware\RateItemDefinitionController@store')->name('mall-software.rate_item_definition.store');
    Route::get('/rate-item-definition-edit/{rateItemDefinition}', 'MallSoftware\RateItemDefinitionController@edit')->name('mall-software.rate_item_definition.edit');
    Route::post('/rate-item-definition-update/{rateItemDefinition}', 'MallSoftware\RateItemDefinitionController@update')->name('mall-software.rate_item_definition.update');
    Route::post('/rate-item-definition-delete/{rateItemDefinition}', 'MallSoftware\RateItemDefinitionController@destroy')->name('mall-software.rate_item_definition.destroy');

    // Lessee Entry
    Route::get('/lessee-entry', 'MallSoftware\LesseeEntryController@index')->name('mall-software.lessee_entry');
    Route::get('/lessee-entry-individual-lessee', 'MallSoftware\LesseeEntryController@individualLesseeList')->name('mall-software.lessee_entry.individualLessee');
    Route::get('/lessee-entry-company-lessee', 'MallSoftware\LesseeEntryController@companyLesseeList')->name('mall-software.lessee_entry.companyLessee');
    Route::get('/lessee-entry-create', 'MallSoftware\LesseeEntryController@create')->name('mall-software.lessee_entry.create');
    Route::get('/lessee-entry-get-states', 'MallSoftware\LesseeEntryController@getStates')->name('mall-software.lessee_entry.getStates');
    Route::get('/lessee-entry-get-districts', 'MallSoftware\LesseeEntryController@getDistricts')->name('mall-software.lessee_entry.getDistricts');
    Route::post('/lessee-entry-store', 'MallSoftware\LesseeEntryController@store')->name('mall-software.lessee_entry.store');
    Route::get('/lessee-entry-individual-lessee-edit/{lesseEntry}', 'MallSoftware\LesseeEntryController@individualLesseEdit')->name('mall-software.lessee_entry.individualLesseeEdit');
    Route::post('/lessee-entry-individual-lessee-update/{lesseEntry}', 'MallSoftware\LesseeEntryController@individualUpdate')->name('mall-software.lessee_entry.individualLesseeUpdate');
    Route::get('/lessee-entry-company-lessee-edit/{lesseEntry}', 'MallSoftware\LesseeEntryController@companyLesseEdit')->name('mall-software.lessee_entry.companyLesseeEdit');
    Route::post('/lessee-entry-company-lessee-update/{lesseEntry}', 'MallSoftware\LesseeEntryController@companyUpdate')->name('mall-software.lessee_entry.companyLesseeUpdate');
    Route::post('/lessee-entry-delete/{lesseEntry}', 'MallSoftware\LesseeEntryController@destroy')->name('mall-software.lessee_entry.destroy');


    // Users
    Route::get('/users', 'MallSoftware\UserController@index')->name('mall-software.users.index');
    Route::get('/users-list', 'MallSoftware\UserController@getUsersList')->name('mall-software.users.list');
    Route::get('/users-create', 'MallSoftware\UserController@create')->name('mall-software.users.create');
    Route::post('/users-store', 'MallSoftware\UserController@store')->name('mall-software.users.store');
    Route::get('/users-edit/{user}', 'MallSoftware\UserController@edit')->name('mall-software.users.edit');
    Route::post('/users-update/{user}', 'MallSoftware\UserController@update')->name('mall-software.users.update');

    // Roles
    Route::get('/roles', 'MallSoftware\RolesController@index')->name('mall-software.roles');
    Route::get('/roles-list', 'MallSoftware\RolesController@getRolesList')->name('mall-software.roleslist');
    Route::get('/roles-create', 'MallSoftware\RolesController@create')->name('mall-software.roles.create');

    //Unit Type Management
    Route::get('/unit-types', 'MallSoftware\UnitTypeManagementController@index')->name('mall-software.unit_type_management.index');
    Route::get('/unit-types-list', 'MallSoftware\UnitTypeManagementController@getList')->name('mall-software.unit_type_management.list');
    Route::get('/unit-types-create', 'MallSoftware\UnitTypeManagementController@create')->name('mall-software.unit_type_management.create');
    Route::post('/unit-types-store', 'MallSoftware\UnitTypeManagementController@store')->name('mall-software.unit_type_management.store');
    Route::get('/unit-types-edit/{types}', 'MallSoftware\UnitTypeManagementController@edit')->name('mall-software.unit_type_management.edit');
    Route::post('/unit-types-update/{types}', 'MallSoftware\UnitTypeManagementController@update')->name('mall-software.unit_type_management.update');
    Route::post('/unit-types-delete/{types}', 'MallSoftware\UnitTypeManagementController@destroy')->name('mall-software.unit_type_management.destroy');

    //Unit Definition Management
    Route::get('/unit-definitions', 'MallSoftware\UnitDefinitionManagementController@index')->name('mall-software.unit_definitions.index');
    Route::get('/unit-definitions-list', 'MallSoftware\UnitDefinitionManagementController@getList')->name('mall-software.unit_definitions.list');
    Route::get('/unit-definitions-create', 'MallSoftware\UnitDefinitionManagementController@create')->name('mall-software.unit_definitions.create');
    Route::post('/unit-definitions-store', 'MallSoftware\UnitDefinitionManagementController@store')->name('mall-software.unit_definitions.store');
    Route::get('/unit-definitions-edit/{unitDefinition}', 'MallSoftware\UnitDefinitionManagementController@edit')->name('mall-software.unit_definitions.edit');
    Route::post('/unit-definitions-update/{unitDefinition}', 'MallSoftware\UnitDefinitionManagementController@update')->name('mall-software.unit_definitions.update');
    Route::post('/unit-definitions-delete/{unitDefinition}', 'MallSoftware\UnitDefinitionManagementController@destroy')->name('mall-software.unit_definitions.destroy');

    // Lease Rental Agreement
    Route::get('/lease-rental-agreement', 'MallSoftware\LeaseRentalAgreementController@index')->name('mall-software.lease_rental_agreement');
    Route::get('/lease-rental-agreement-list', 'MallSoftware\LeaseRentalAgreementController@getList')->name('mall-software.lease_rental_agreement.list');
    Route::get('/lease-rental-agreement-create', 'MallSoftware\LeaseRentalAgreementController@create')->name('mall-software.lease_rental_agreement.create');
    Route::get('/lease-rental-view-agreement/{leaseRentalAgreement}', 'MallSoftware\LeaseRentalAgreementController@viewAgreement')->name('mall-software.lease_rental_agreement.viewAgreement');
    Route::get('/lease-rental-view-agreement-list/{leaseRentalAgreement}', 'MallSoftware\LeaseRentalAgreementController@viewAgreementList')->name('mall-software.lease_rental_agreement.viewAgreementList');
    Route::post('/lease-rental-agreement-store', 'MallSoftware\LeaseRentalAgreementController@store')->name('mall-software.lease_rental_agreement.store');
    Route::get('/lease-rental-agreement-unit-list', 'MallSoftware\LeaseRentalAgreementController@getUnitList')->name('mall-software.lease_rental_agreement.getUnits');
    Route::get('/lease-rental-agreement-floors-list', 'MallSoftware\LeaseRentalAgreementController@getFloorsList')->name('mall-software.lease_rental_agreement.getFloors');
    Route::get('/lease-rental-agreement-get-total', 'MallSoftware\LeaseRentalAgreementController@getTotal')->name('mall-software.lease_rental_agreement.getTotal');
    Route::get('/security-deposit-list', 'MallSoftware\LeaseRentalAgreementController@getSecurityDepositList')->name('mall-software.lease_rental_agreement.getSecurityDepositList');
    Route::get('/fixed-charges-list', 'MallSoftware\LeaseRentalAgreementController@getFixedChargesList')->name('mall-software.lease_rental_agreement.getFixedChargesList');
    Route::get('/variable-charges-list', 'MallSoftware\LeaseRentalAgreementController@getVariableChargesList')->name('mall-software.lease_rental_agreement.getVariableChargesList');
    Route::get('/lease-rental-agreement-edit/{leaseRentalAgreement}', 'MallSoftware\LeaseRentalAgreementController@edit')->name('mall-software.lease_rental_agreement.edit');
    Route::post('/lease-rental-agreement-update/{leaseRentalAgreement}', 'MallSoftware\LeaseRentalAgreementController@update')->name('mall-software.lease_rental_agreement.update');
    Route::post('/lease-rental-agreement-destroy/{leaseRentalAgreement}', 'MallSoftware\LeaseRentalAgreementController@destroy')->name('mall-software.lease_rental_agreement.destroy');

    // Companies
    Route::get('/companies', 'MallSoftware\CompanyController@index')->name('mall-software.companies');
    Route::get('/companies-list', 'MallSoftware\CompanyController@getCompanyList')->name('mall-software.company_list');
    Route::get('/companies-create', 'MallSoftware\CompanyController@create')->name('mall-software.companies_create');
    Route::post('/companies-create', 'MallSoftware\CompanyController@store')->name('mall-software.companies_store');
    Route::get('/companies-edit/{company}', 'MallSoftware\CompanyController@edit')->name('mall-software.companies_edit');

    // Rent Receipt
    Route::get('/rent-receipt', 'MallSoftware\RentReceipt\RentReceiptController@index')->name('mall-software.rent_receipt.index');
    Route::get('/rent-receipt-create', 'MallSoftware\RentReceipt\RentReceiptController@create')->name('mall-software.rent_receipt.create');

    // Bill Details Entry
    // Route::get('/bill-details-entry', 'MallSoftware\BillDetailsEntryController@index')->name('mall-software.bill_details_entry');
    Route::get('/bill-details-fixed-charges', 'MallSoftware\BillDetailsEntryController@fixedChargesIndex')->name('mall-software.bill_details_fixed_charges');
    Route::get('/bill-details-variable-charges', 'MallSoftware\BillDetailsEntryController@variableChargesIndex')->name('mall-software.bill_details_variable_charges');
    Route::get('/bill-details-deposits', 'MallSoftware\BillDetailsEntryController@depositsIndex')->name('mall-software.bill_details_deposits');
    Route::get('/bill-details-other-charges', 'MallSoftware\BillDetailsEntryController@otherChargesIndex')->name('mall-software.bill_details_other_charges');

    // All Bills
    Route::get('/all-bills', 'MallSoftware\BillController@index')->name('mall-software.all_bills');


    // Projects
    Route::get('/projects', 'MallSoftware\ProjectController@index')->name('mall-software.projects.index');
    Route::get('/projects-list', 'MallSoftware\ProjectController@getProjectList')->name('mall-software.projects.list');
    Route::get('/projects-create', 'MallSoftware\ProjectController@create')->name('mall-software.projects.create');
});
