<?php $__env->startSection('css'); ?>
    <style>
        #rateTypeErrorContainer,
        #groupSelectErrorContainer,
        #ledgerSelectErrorContainer,
        #dueDaysErrorContainer,
        #rateItemErrorContainer,
        .parsley-errors-list {
            margin-top: 5px;
            list-style-type: none;
            padding: 0;
            font-size: 0.8rem;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Edit Rate Item Definition</h5>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        
                        
                        <div class="success-alert-bar p-15 m-b-20 green white-text" id="outletdeleteMsg"
                            style="display: none">
                            Outlet Successfully Deleted
                        </div>

                        <?php if($message = Session::get('success')): ?>
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                <?php echo e($message); ?>

                            </div>
                        <?php endif; ?>
                        <?php if($message = Session::get('error')): ?>
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                <?php echo e($message); ?>

                            </div>
                        <?php endif; ?>

                        <form method="post"
                            action="<?php echo e(route('mall-software.rate_item_definition.update', $rateItemDefinition)); ?>"
                            class="formValidate" id="form" name="formValidate" data-parsley-validate="">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="rate_type" id="rate_type" required=""
                                        data-parsley-required-message="Rate Type is required"
                                        data-parsley-errors-container="#rateTypeErrorContainer"
                                        class="browser-default select2">
                                        <option value=""></option>
                                        <option value="Security Deposit" <?php if($rateItemDefinition->rate_type == 'Security Deposit'): ?> selected <?php endif; ?>>
                                            Security Deposit</option>
                                        <option value="Fixed Charges" <?php if($rateItemDefinition->rate_type == 'Fixed Charges'): ?> selected <?php endif; ?>>
                                            Fixed Charges</option>
                                        <option value="Variable Charges" <?php if($rateItemDefinition->rate_type == 'Variable Charges'): ?> selected <?php endif; ?>>
                                            Variable Charges</option>
                                    </select>
                                    <label for="rate_type" style="color: red" class="active">Rate Type<span
                                            class="red-star">*</span></label>
                                    <span id="rateTypeErrorContainer"></span>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <input id="rate_item_name" type="text" name="rate_item_name"
                                        value="<?php echo e($rateItemDefinition->rate_item_name); ?>" required=""
                                        data-parsley-required-message="Rate Item Name is required"
                                        data-parsley-errors-container="#rateItemErrorContainer">
                                    <label for="rate_item_name" class="active" style="color: red">Rate Item
                                        Name<span class="red-star">*</span></label>
                                    <span id="rateItemErrorContainer"></span>
                                </div>

                                <div class="input-field col s12 m4 project-type-wrapper" id="rate_calculation">
                                    <div class="input-field col s12 m4">
                                        <label>
                                            <input id="rate_calculation_method1" type="radio"
                                                name="rate_calculation_method" value="Area"
                                                <?php if($rateItemDefinition->rate_calculation_method == 'Area'): ?> checked <?php endif; ?> />
                                            <span style="font-weight: bold; color: black">Area</span>
                                        </label>
                                    </div>

                                    <div class="input-field col s12 m4">
                                        <label>
                                            <input id="rate_calculation_method2" type="radio"
                                                name="rate_calculation_method" value="Quantity"
                                                <?php if($rateItemDefinition->rate_calculation_method == 'Quantity'): ?> checked <?php endif; ?> />
                                            <span style="font-weight: bold; color: black">Quantity</span>
                                        </label>
                                    </div>

                                    <div class="input-field col s12 m4">
                                        <label>
                                            <input id="rate_calculation_method3" type="radio"
                                                name="rate_calculation_method" value="Lumpsum"
                                                <?php if($rateItemDefinition->rate_calculation_method == 'Lumpsum'): ?> checked <?php endif; ?> />
                                            <span style="font-weight: bold; color: black">Lumpsum</span>
                                        </label>
                                    </div>

                                    <label for="rate_calculation" id="rate_calculation_label" class="active"
                                        style="color: red">Rate Calculation Method<span class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <input id="default_rate" type="text" name="default_rate"
                                        value="<?php echo e($rateItemDefinition->default_rate); ?>" data-parsley-type="number">
                                    <label for="default_rate" class="active">Default Rate</label>
                                </div>

                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <input id="remarks" type="text" name="remarks"
                                        value="<?php echo e($rateItemDefinition->remarks); ?>">
                                    <label for="remarks">Remarks</label>
                                </div>

                                <div class="input-field col s12 m2">
                                    <select name="gst_percentage" id="gst_percentage" class="browser-default select2">
                                        <option value=""></option>
                                        <option value="5"<?php if($rateItemDefinition->gst_percentage == 5): ?> selected <?php endif; ?>>5</option>
                                        <option value="12"<?php if($rateItemDefinition->gst_percentage == 12): ?> selected <?php endif; ?>>12</option>
                                        <option value="18"<?php if($rateItemDefinition->gst_percentage == 18): ?> selected <?php endif; ?>>18</option>
                                        <option value="28"<?php if($rateItemDefinition->gst_percentage == 28): ?> selected <?php endif; ?>>28</option>
                                    </select>
                                    <label for="gst_percentage" class="active">GST %</label>
                                </div>

                                <div class="input-field col s12 m2">
                                    <select name="tds_percentage" id="tds_percentage" class="browser-default select2">
                                        <option value=""></option>
                                        <option value="1"<?php if($rateItemDefinition->tds_percentage == 1): ?> selected <?php endif; ?>>1
                                        </option>
                                        <option value="2"<?php if($rateItemDefinition->tds_percentage == 2): ?> selected <?php endif; ?>>2
                                        </option>
                                        <option value="10"<?php if($rateItemDefinition->tds_percentage == 10): ?> selected <?php endif; ?>>10
                                        </option>
                                    </select>
                                    <label for="tds_percentage" class="active">TDS %</label>
                                </div>

                                <div class="input-field col s12 m2">
                                    <select name="other_taxes" id="other_taxes" class="browser-default select2">
                                        <option value="">---Select---</option>
                                    </select>
                                    <label for="other_taxes" class="active">Other Taxes %</label>
                                </div>

                                <div class="input-field col s12 m3">
                                    <input id="due_days" type="text" name="due_days"
                                        value="<?php echo e($rateItemDefinition->due_days); ?>" required=""
                                        data-parsley-type="integer" data-parsley-required-message="Due Days is required"
                                        data-parsley-errors-container="#dueDaysErrorContainer">
                                    <label for="due_days" style="color: red" class="active">Due days<span
                                            class="red-star">*</span></label>
                                    <span id="dueDaysErrorContainer"></span>
                                </div>

                                <div class="input-field col s12 m1">
                                    <label>
                                        <input id="due_days1" type="checkbox"
                                            <?php echo e($rateItemDefinition->is_active == 1 ? 'checked' : ''); ?> checked
                                            name="active" value="1" />
                                        <span style="font-weight: bold; color: black">Active</span>
                                    </label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <input id="hsn-sac-code" type="text" name="hsn-sac-code"
                                        value="<?php echo e($rateItemDefinition->hsn_sac_code); ?>">
                                    <label for="hsn-sac-code"class="active">HSN/SAC Code</label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <select name="group_select" id="group_select" required=""
                                        data-parsley-required-message="COA is required"
                                        data-parsley-errors-container="#groupSelectErrorContainer"
                                        class="browser-default select2">
                                        <option value="">---Group Select---</option>
                                        <?php $__currentLoopData = $ledgerGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ledgerGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($ledgerGroup->id); ?>"
                                                <?php if($ledgerGroup->id == $rateItemDefinition->coa_group): ?> selected <?php endif; ?>>
                                                <?php echo e($ledgerGroup->ledger_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label for="group_select" style="color: red" class="active">COA*</label>
                                    <span id="groupSelectErrorContainer"></span>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper" id="individual_select_div">
                                    <select name="individual_ledger" id="individual_ledger" required=""
                                        data-parsley-required-message="Ledger is required"
                                        data-parsley-errors-container="#ledgerSelectErrorContainer"
                                        class="browser-default select2">
                                        <option value="">---Ledger Select---</option>
                                        <?php $__currentLoopData = $ledgers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ledger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($ledger->id); ?>"
                                                <?php if($ledger->id == $rateItemDefinition->ledger_type): ?> selected <?php endif; ?>>
                                                <?php echo e($ledger->ledger_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label for="individual_ledger" style="color: red" class="active">Ledger</label>
                                    <span id="ledgerSelectErrorContainer"></span>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <button class="btn" id="automatic_numbering_btn" type="button">Automatic
                                        Numbering</button>
                                </div>
                            </div>

                            <div class="" id="automatic_numbering_div">
                                <div class="row">
                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="text" name="prefix" id="prefix"
                                            value="<?php echo e($rateItemDefinition->prefix); ?>">
                                        <label for="" style="color: red" class="active">Prefix*</label>
                                    </div>
                                    <div class="input-field col s12 m2">
                                        <label>
                                            <input id="company_short_name" type="checkbox" name="company_short_name" />
                                            <span style="font-weight: bold; color: black">Company Short Name</span>
                                        </label>
                                    </div>

                                    <div class="input-field col s12 m2">
                                        <label>
                                            <input id="project_short_name" type="checkbox" name="project_short_name" />
                                            <span style="font-weight: bold; color: black">Project Short Name</span>
                                        </label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="text" name="financial_year" id="financial_year"
                                            value="<?php echo e($rateItemDefinition->financial_year); ?>">
                                        <label for="financial_year" style="color: red" class="active">Financial
                                            year</label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="text" name="next_number" id="next_number"
                                            data-parsley-type="integer">
                                        <label for="next_number" class="active">Next
                                            number.</label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="text" name="reset_number" id="reset_number"
                                            data-parsley-type="integer">
                                        <label for="reset_number" class="active">Reset number
                                            to.</label>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <button class="btn" type="submit">Update</button>
                                    <a href="<?php echo e(route('mall-software.rate_item_definition')); ?>" class="btn"
                                        type="btn">Cancel</a>
                                </div>
                            </div>

                        </form>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
    <script>
        $(document).ready(function() {

            $('#automatic_numbering_div').hide();
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });

            $('#form').parsley();
            $('#company_short_name').change(function() {
                if ($(this).is(":checked")) {
                    $('#company-separator-wrapper').show();
                } else {
                    $('#company-separator-wrapper').hide();
                }
            });

            $('#project_short_name').change(function() {
                if ($(this).is(":checked")) {
                    $('#project-separator-wrapper').show();
                } else {
                    $('#project-separator-wrapper').hide();
                }
            });

            $('#automatic_numbering_btn').click(function() {
                $('#automatic_numbering_div').toggle();

                if ($('#automatic_numbering_div').is(':visible')) {
                    $('#prefix').attr('required', '');
                    $('#prefix').attr('data-parsley-required-message',
                        'Prefix is required');
                    $('#prefix').parsley().reset();
                } else {
                    $('#prefix').removeAttr('required');
                    $('#prefix').parsley().reset();
                }
            });
        })
    </script>

    <script>
        $(document).ready(function() {
            $('#company_separator').on('input', function() {
                var inputValue = $(this).val();
                var sanitizedValue = inputValue.replace(/[^!@#$%^&*(),.?":{}|<>]/g, '');
                $(this).val(sanitizedValue);
            });

            window.Parsley.addValidator('alphaOnly', {
                validateString: function(value) {
                    return /^[A-Za-z]+$/.test(value);
                },
                messages: {
                    en: 'Please enter only alphabetical characters.'
                }
            });
            $('#prefix').parsley().addConstraint('alphaOnly');

            $('#group_select').on('change', function() {
                $('#individual_ledger').empty();
                let coa_id = $(this).val();
                let ledgerID = <?php echo e($rateItemDefinition->ledger_type); ?>;
                console.log(ledgerID);
                if (coa_id !== '') {
                    $.ajax({
                        url: '<?php echo e(route('mall-software.rate_item_definition.getLedgers')); ?>',
                        type: 'GET',
                        data: {
                            coa_id: coa_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    var selected = ledgerID == value.id ? 'selected' :
                                        '';
                                    html += '<option value="' + value.id + '"' +
                                        selected + '>' + value
                                        .ledger_name + '</option>';
                                });
                                $('#individual_ledger').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#individual_ledger').html('<option value="">Choose State</option>');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/loginhilitemall/public_html/hilite-mall-software/leads/resources/views/mall_software/rate_item_definition/edit.blade.php ENDPATH**/ ?>