<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Rate Item Definition</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="<?php echo e(route('dashboard.home')); ?>" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="#" class="breadcrumb">Rate Item Definitions</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        
                        <?php if($message = Session::get('success')): ?>
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                <?php echo e($message); ?>

                            </div>
                        <?php endif; ?>
                        <?php if($message = Session::get('error')): ?>
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                <?php echo e($message); ?>

                            </div>
                        <?php endif; ?>
                        <div>
                            <a href="<?php echo e(route('mall-software.rate_item_definition.create')); ?>" class="btn">Create</a>
                        </div>

                        <div>
                            <table id="rate_definition_tbl" class="responsive-table display nowrap" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>SL No.</th>
                                        <th>Rate Type</th>
                                        <th>Rate Item Name</th>
                                        <th>Rate Calculation Method</th>
                                        <th>Due Days</th>
                                        <th>COA</th>
                                        <th>Ledger Name</th>
                                        <th>Prefix</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        $(document).ready(function() {
            var outletTbl = $('#rate_definition_tbl').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "<?php echo e(route('mall-software.rate_item_definition.list')); ?>",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate_type',
                        name: 'rate_type'
                    },
                    {
                        data: 'rate_item_name',
                        name: 'rate_item_name'
                    },
                    {
                        data: 'rate_calculation_method',
                        name: 'rate_calculation_method'
                    },
                    {
                        data: 'due_days',
                        name: 'due_days'
                    },
                    {
                        data: 'coa_group',
                        name: 'coa_group'
                    },
                    {
                        data: 'ledger_name',
                        name: 'ledger_name'
                    },
                    {
                        data: 'prefix',
                        name: 'prefix'
                    },
                    {
                        data: 'actions',
                        name: 'actions'
                    },
                ],
                "order": [
                    [1, "desc"]
                ],
                "drawCallback": function(settings) {
                    //alert( 'DataTables has redrawn the table' );
                    $('.dropdown-trigger').dropdown();
                },
                //dom: 'lBfrtip',//to hide lengthmenu dropdown use dom:Bfrtip
                // Configure the drop down options.
                lengthMenu: [
                    [10, 25, 50, 100, -1],
                    ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                ],
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/loginhilitemall/public_html/hilite-mall-software/leads/resources/views/mall_software/rate_item_definition/index.blade.php ENDPATH**/ ?>