<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Create Lease Rental Agreement</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="<?php echo e(route('dashboard.home')); ?>" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="<?php echo e(route('mall-software.lease_rental_agreement')); ?>" class="breadcrumb">Lease Rental Agreement</a>
                <a href="#" class="breadcrumb">Create Agreement</a>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>

                        <form method="post" action="<?php echo e(route('mall-software.lease_rental_agreement.store')); ?>"
                            class="formValidate" id="formValidate" name="formValidate" data-parsely-validate="">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="agreement_no" id="agreement_no" class="" />
                                    <label for="agreement_no" style="color: red">Agreement No.<span
                                            class="red-star">*</span></label>
                                    
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="project" id="projects_list" class="browser-default select2">
                                        <option value="">---Select---</option>
                                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($project->id); ?>"><?php echo e($project->project_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label for="project" style="color: red" class="active">Project<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="project_unit" class="browser-default select2" id="project_units_list">
                                        <option value="">---Select---</option>
                                    </select>
                                    <label for="project_unit" style="color: red" class="active">Project Units<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="floor" id="floor" readonly>
                                    <label for="floor" style="color: red" class="active">Floor<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">

                                    <input type="text" name="type" id="type" readonly>
                                    <label for="type" style="color: red" class="active">Type<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="type_area" id="type_area" data-parsley-type="number">
                                    <label for="type_area" id="type_area_lbl" style="color: red">Area<span
                                            class="red-star active">*</span></label>
                                </div>

                            </div>

                            <div class="row">

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="lessee" id="lessee" class="browser-default select2">
                                        <option value="">---Select---</option>
                                        <?php $__currentLoopData = $lesseeData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lessee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($lessee->lessee_type == 'Individual'): ?>
                                                <option value="<?php echo e($lessee->id); ?>"><?php echo e($lessee->individual_name); ?></option>
                                            <?php elseif($lessee->lessee_type == 'Company'): ?>
                                                <option value="<?php echo e($lessee->id); ?>"><?php echo e($lessee->company_name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label for="lessee" style="color: red" class="active">Lessee<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="date" name="agreement_date" id="agreement_date">
                                    <label for="agreement_date" style="color: red">Agreement Date<span
                                            class="red-star">*</span></label>
                                </div>
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="date" name="agreement_period_from" id="agreement_period_from">
                                    <label for="agreement_period_from" style="color: red">Agreement Period From<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="date" name="agreement_period_to" id="agreement_period_to">
                                    <label for="agreement_period_to" style="color: red">Agreement Period To<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="registration_charges" id="registration_charges"
                                        class="" data-parsley-type="number" />
                                    <label for="registration_charges" style="color: red">Registration Charges<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="notice_period" id="notice_period" class=""
                                        data-parsley-type="integer" />
                                    <label for="notice_period" style="color: red">Notice Period (In months)<span
                                            class="red-star">*</span></label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="date" name="rent_start_date" id="rent_start_date">
                                    <label for="rent_start_date" style="color: red">Rent Start Date<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <label>
                                        <input id="revenuew_sharing" type="checkbox" name="revenuew_sharing" />
                                        <span style="font-weight: bold; color: black">Revenue Sharing</span>
                                    </label>
                                </div>

                                
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col s12 l12">
                                    <ul class="tabs tab-demo z-depth-1">
                                        <li class="tab"><a href="#security_deposit">Security Deposit</a></li>
                                        <li class="tab"><a class="active" href="#fixed_charges">Fixed Charges</a>
                                        </li>
                                        <li class="tab"><a href="#variable_charges">Variable Charges</a></li>
                                    </ul>
                                    <div id="security_deposit">
                                        <div class="row">
                                            <div class="col s12 l12">
                                                <p>

                                                </p>
                                                <table id="security_deposit_table" class="responsive-table display"
                                                    style="width:100%">
                                                    <thead>
                                                        <tr>
                                                            <th>
                                                                Sl.No.
                                                            </th>
                                                            <th><label><input data-id=""
                                                                        id="security_deposit_select_all"
                                                                        class="security_deposit_select_all"
                                                                        type="checkbox" /><span
                                                                        style="color: black"></span></label></th>
                                                            <th width="50%">
                                                                Rate Item Name
                                                            </th>
                                                            <th>
                                                                Rate Calculation Method
                                                            </th>
                                                            <th>
                                                                Area
                                                            </th>
                                                            <th>
                                                                Rate
                                                            </th>
                                                            <th>
                                                                Total Amount
                                                            </th>
                                                            <th>
                                                                GST Rate
                                                            </th>
                                                            <th>
                                                                GST Amount
                                                            </th>
                                                            <th>
                                                                TDS Rate
                                                            </th>
                                                            <th>
                                                                TDS Amount
                                                            </th>
                                                            <th>
                                                                Other Taxes
                                                            </th>
                                                            <th>
                                                                Net Amount
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>


                                    <div id="fixed_charges">
                                        <div class="row">
                                            <div class="col s12 l12">
                                                <p>

                                                </p>
                                                <table id="fixed_charges_table" class="responsive-table display"
                                                    style="width:100%">
                                                    <thead>
                                                        <tr>
                                                            <th>
                                                                Sl.No.
                                                            </th>
                                                            <th><label><input data-id="" id="fixed_charges_select_all"
                                                                        class="fixed_charges_select_all"
                                                                        type="checkbox" /><span
                                                                        style="color: black"></span></label></th>
                                                            <th>
                                                                Rate Item Name
                                                            </th>
                                                            <th>
                                                                Rate Calculation Method
                                                            </th>
                                                            <th>
                                                                Area
                                                            </th>
                                                            <th>
                                                                Rate
                                                            </th>
                                                            <th>
                                                                Total Amount
                                                            </th>
                                                            <th>
                                                                GST Rate
                                                            </th>
                                                            <th>
                                                                GST Amount
                                                            </th>
                                                            <th>
                                                                TDS Rate
                                                            </th>
                                                            <th>
                                                                TDS Amount
                                                            </th>
                                                            <th>
                                                                Other Taxes
                                                            </th>
                                                            <th>
                                                                Net Amount
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>


                                    <div id="variable_charges">
                                        <div class="row">
                                            <div class="col s12 l12">
                                                <p>

                                                </p>
                                                <table id="variable_charges_table" class="responsive-table display"
                                                    style="width:100%">
                                                    <thead>
                                                        <tr>
                                                            <th>
                                                                Sl.No.
                                                            </th>
                                                            <th><label><input data-id=""
                                                                        id="variable_charges_select_all"
                                                                        class="variable_charges_select_all"
                                                                        type="checkbox" /><span
                                                                        style="color: black"></span></label></th>
                                                            <th>
                                                                Rate Item Name
                                                            </th>
                                                            <th>
                                                                Rate
                                                            </th>
                                                            
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="submit" class="btn" value="Save">
                                    <a href="<?php echo e(route('mall-software.lease_rental_agreement')); ?>" class="btn"
                                        type="btn">Cancel</a>

                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
    <script>
        $(document).ready(function() {
            // $('#formValidate').parsley();

            $('#mySelect').on('select2:select', function(e) {
                $(this).parsley().validate();
            });
        });
    </script>


    <script>
        $(document).ready(function() {
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });

            let security_deposit_table = $('#security_deposit_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "<?php echo e(route('mall-software.lease_rental_agreement.getSecurityDepositList')); ?>",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'checkbox',
                        name: 'checkbox',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate_item_name',
                        name: 'rate_item_name'
                    },
                    {
                        data: 'calculation_method',
                        name: 'calculation_method'
                    },
                    {
                        data: 'area_input',
                        name: 'area_input'
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                    {
                        data: 'total_amount',
                        name: 'total_amount'
                    },
                    {
                        data: 'GST_rate',
                        name: 'GST_rate'
                    },
                    {
                        data: 'GST_Amount',
                        name: 'GST_Amount'
                    },
                    {
                        data: 'TDS_rate',
                        name: 'TDS_rate'
                    },
                    {
                        data: 'TDS_Amount',
                        name: 'TDS_Amount'
                    },
                    {
                        data: 'Other Taxes',
                        name: 'Other Taxes'
                    },
                    {
                        data: 'Net_Amount',
                        name: 'Net_Amount'
                    },
                ],
            });
            $('#security_deposit_select_all').on('click', function() {
                var rows = security_deposit_table.rows({
                    'search': 'applied'
                }).nodes();
                $('input[type="checkbox"]', rows).prop('checked', this
                    .checked);

                $('input[type="checkbox"]', rows).each(
                    function() {
                        selectSecurityDeposits.call(this);
                    });
            });


            let fixed_charges_table = $('#fixed_charges_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "<?php echo e(route('mall-software.lease_rental_agreement.getFixedChargesList')); ?>",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'checkbox',
                        name: 'checkbox',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate_item_name',
                        name: 'rate_item_name'
                    },
                    {
                        data: 'calculation_method',
                        name: 'calculation_method'
                    },
                    {
                        data: 'area_input',
                        name: 'area_input'
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                    {
                        data: 'total_amount',
                        name: 'total_amount'
                    },
                    {
                        data: 'GST_rate',
                        name: 'GST_rate'
                    },
                    {
                        data: 'GST_Amount',
                        name: 'GST_Amount'
                    },
                    {
                        data: 'TDS_rate',
                        name: 'TDS_rate'
                    },
                    {
                        data: 'TDS_Amount',
                        name: 'TDS_Amount'
                    },
                    {
                        data: 'Other Taxes',
                        name: 'Other Taxes'
                    },
                    {
                        data: 'Net_Amount',
                        name: 'Net_Amount'
                    },
                ],
            });
            $('#fixed_charges_select_all').on('click', function() {
                var rows = fixed_charges_table.rows({
                    'search': 'applied'
                }).nodes();
                $('input[type="checkbox"]', rows).prop('checked', this
                    .checked);
                $('input[type="checkbox"]', rows).each(
                    function() {
                        fixedCharges.call(this);
                    });
            });


            let variable_charges_table = $('#variable_charges_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "<?php echo e(route('mall-software.lease_rental_agreement.getVariableChargesList')); ?>",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'checkbox',
                        name: 'checkbox',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate_item_name',
                        name: 'rate_item_name'
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                    // {
                    //     data: 'amount',
                    //     name: 'amount'
                    // },
                ],
            });
            $('#variable_charges_select_all').on('click', function() {
                var rows = variable_charges_table.rows({
                    'search': 'applied'
                }).nodes();
                $('input[type="checkbox"]', rows).prop('checked', this
                    .checked);
            });


            $('#projects_list').on('change', function() {
                $('#project_units_list').empty();
                $('#floor').val('');
                $('#type').val('');
                $('#type_area').val('');
                let project_id = $(this).val();
                if (project_id != "") {
                    $.ajax({
                        url: '<?php echo e(route('mall-software.lease_rental_agreement.getUnits')); ?>',
                        type: 'GET',
                        data: {
                            project_id: project_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose Unit</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .unit_name + '</option>';
                                });
                                $('#project_units_list').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#project_units_list').html('<option value="">Choose Unit</option>');
                }
            });

            $('#project_units_list').on('change', function() {
                let unit_id = $(this).val();
                if (unit_id != "") {
                    $.ajax({
                        url: '<?php echo e(route('mall-software.lease_rental_agreement.getFloors')); ?>',
                        type: 'GET',
                        data: {
                            unit_id: unit_id
                        },
                        success: function(response) {
                            if (response.status) {
                                $('#floor').val(response.data.floor.name).focus();
                                $('#type').val(response.data.unit_types.type).focus();
                                $('#type_area').val(response.data.unit_types.area).focus();
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                }
            });
        });


        // FIXED CHARGES TABLE DATA CALCULATION
        $(document).on('click', '.fixedCharges', function() {
            fixedCharges.call(this);
        });

        function fixedCharges() {
            var fixedChargeId = $(this).data('id');
            if ($(this).is(':checked')) {
                $('.fixed_charges_area_input_' + fixedChargeId).val($('#type_area').val());

                let area_value = $('.fixed_charges_area_input_' + fixedChargeId).val();
                let rate_amount = $('.rate_amount_' + fixedChargeId).val();
                let gst_rate = $('.gst_rate_' + fixedChargeId).val();
                let tds_rate = $('.tds_rate_' + fixedChargeId).val();
                $.ajax({
                    url: '<?php echo e(route('mall-software.lease_rental_agreement.getTotal')); ?>',
                    type: 'GET',
                    data: {
                        area_value: area_value,
                        rate_amount: rate_amount,
                        gst_rate: gst_rate,
                        tds_rate: tds_rate,
                    },
                    success: function(response) {
                        console.log(response);
                        $('.total_amount_' + fixedChargeId).val(response.total_amount);
                        $('.gst_amount_' + fixedChargeId).val(response.gst_amount);
                        $('.tds_amount_' + fixedChargeId).val(response.tds_amount);
                        $('.net_amount_' + fixedChargeId).val(response.net_amount);
                    }
                });

                $('.fixed_charges_area_input_' + fixedChargeId).on('keyup', function() {
                    let area_value = $('.fixed_charges_area_input_' + fixedChargeId).val();
                    let rate_amount = $('.rate_amount_' + fixedChargeId).val();
                    let gst_rate = $('.gst_rate_' + fixedChargeId).val();
                    let tds_rate = $('.tds_rate_' + fixedChargeId).val();
                    if (area_value != '') {
                        $.ajax({
                            url: '<?php echo e(route('mall-software.lease_rental_agreement.getTotal')); ?>',
                            type: 'GET',
                            data: {
                                area_value: area_value,
                                rate_amount: rate_amount,
                                gst_rate: gst_rate,
                                tds_rate: tds_rate,
                            },
                            success: function(response) {
                                console.log(response);
                                $('.total_amount_' + fixedChargeId).val(response.total_amount);
                                $('.gst_amount_' + fixedChargeId).val(response.gst_amount);
                                $('.tds_amount_' + fixedChargeId).val(response.tds_amount);
                                $('.net_amount_' + fixedChargeId).val(response.net_amount);
                            }
                        });
                    } else {
                        $('.fixed_charges_area_input_' + fixedChargeId).val('');
                        $('.total_amount_' + fixedChargeId).val('');
                        $('.gst_amount_' + fixedChargeId).val('');
                        $('.tds_amount_' + fixedChargeId).val('');
                        $('.net_amount_' + fixedChargeId).val('');
                    }
                });

            } else {
                $('.fixed_charges_area_input_' + fixedChargeId).val('');
                $('.total_amount_' + fixedChargeId).val('');
                $('.gst_amount_' + fixedChargeId).val('');
                $('.tds_amount_' + fixedChargeId).val('');
                $('.net_amount_' + fixedChargeId).val('');
            }
        }


        // SECURITY DEPOSIT TABLE DATA CALCULATION
        $(document).on('click', '.security_deposit', function() {
            selectSecurityDeposits.call(this);
        });

        function selectSecurityDeposits() {
            var securityDepositId = $(this).data('id');
            if ($(this).is(':checked')) {
                $('.security_deposit_area_input_' + securityDepositId).val($('#type_area').val());

                let area_value = $('.security_deposit_area_input_' + securityDepositId).val();
                let rate_amount = $('.rate_amount_' + securityDepositId).val();
                let gst_rate = $('.gst_rate_' + securityDepositId).val();
                let tds_rate = $('.tds_rate_' + securityDepositId).val();
                $.ajax({
                    url: '<?php echo e(route('mall-software.lease_rental_agreement.getTotal')); ?>',
                    type: 'GET',
                    data: {
                        area_value: area_value,
                        rate_amount: rate_amount,
                        gst_rate: gst_rate,
                        tds_rate: tds_rate,
                    },
                    success: function(response) {
                        console.log(response);
                        $('.total_amount_' + securityDepositId).val(response.total_amount);
                        $('.gst_amount_' + securityDepositId).val(response.gst_amount);
                        $('.tds_amount_' + securityDepositId).val(response.tds_amount);
                        $('.net_amount_' + securityDepositId).val(response.net_amount);
                    }
                });

                $('.security_deposit_area_input_' + securityDepositId).on('keyup', function() {
                    let area_value = $('.security_deposit_area_input_' + securityDepositId).val();
                    let rate_amount = $('.rate_amount_' + securityDepositId).val();
                    let gst_rate = $('.gst_rate_' + securityDepositId).val();
                    let tds_rate = $('.tds_rate_' + securityDepositId).val();
                    if (area_value != '') {
                        $.ajax({
                            url: '<?php echo e(route('mall-software.lease_rental_agreement.getTotal')); ?>',
                            type: 'GET',
                            data: {
                                area_value: area_value,
                                rate_amount: rate_amount,
                                gst_rate: gst_rate,
                                tds_rate: tds_rate,
                            },
                            success: function(response) {
                                console.log(response);
                                $('.total_amount_' + securityDepositId).val(response
                                    .total_amount);
                                $('.gst_amount_' + securityDepositId).val(response
                                    .gst_amount);
                                $('.tds_amount_' + securityDepositId).val(response
                                    .tds_amount);
                                $('.net_amount_' + securityDepositId).val(response
                                    .net_amount);
                            }
                        });
                    } else {
                        $('.security_deposit_area_input_' + securityDepositId).val('');
                        $('.total_amount_' + securityDepositId).val('');
                        $('.gst_amount_' + securityDepositId).val('');
                        $('.tds_amount_' + securityDepositId).val('');
                        $('.net_amount_' + securityDepositId).val('');
                    }
                })
            } else {
                $('.security_deposit_area_input_' + securityDepositId).val('');
                $('.total_amount_' + securityDepositId).val('');
                $('.gst_amount_' + securityDepositId).val('');
                $('.tds_amount_' + securityDepositId).val('');
                $('.net_amount_' + securityDepositId).val('');
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/loginhilitemall/public_html/hilite-mall-software/leads/resources/views/mall_software/lease_rental_agreement/create.blade.php ENDPATH**/ ?>