<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Unit Definitions</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="<?php echo e(route('dashboard.home')); ?>" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="#" class="breadcrumb">Unit Definitions</a>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>
                        <div>
                            <a href="<?php echo e(route('mall-software.unit_definitions.create')); ?>" class="btn">Create Unit
                                Definition</a>
                        </div>
                        <br>
                        <?php if($message = Session::get('success')): ?>
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                <?php echo e($message); ?>

                            </div>
                        <?php endif; ?>
                        <?php if($message = Session::get('error')): ?>
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                <?php echo e($message); ?>

                            </div>
                        <?php endif; ?>

                        <div class="row">
                            <table id="unit_definitions_table" class="responsive-table display" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>SL No.</th>
                                        <th>Unit Name</th>
                                        <th>Project Name</th>
                                        <th>Block</th>
                                        <th>Type</th>
                                        <th>Floor</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        //get all data to table
        $(function() {
            $('#unit_definitions_table').DataTable({
                retrieve: true,
                processing: true,
                serverSide: true,
                sScrollX: false,
                ajax: '<?php echo e(route('mall-software.unit_definitions.list')); ?>',
                scrollX: true,
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'unit_name',
                    },
                    {
                        data: 'projects',
                    },
                    {
                        data: 'block',
                    },
                    {
                        data: 'types',
                    },
                    {
                        data: 'floors',
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                    },
                ]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/loginhilitemall/public_html/hilite-mall-software/leads/resources/views/mall_software/unit_definitions/index.blade.php ENDPATH**/ ?>