<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Edit Lease Rental Agreement</h5>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>

                        <form method="post" action="<?php echo e(route('mall-software.lease_rental_agreement.store')); ?>"
                            class="formValidate" id="formValidate" name="formValidate" data-parsely-validate="">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="agreement_no" id="agreement_no" value="<?php echo e($leaseRentalAgreement->agreement_no); ?>" class="" required />
                                    <label for="agreement_no" style="color: red">Agreement No.<span
                                            class="red-star">*</span></label>
                                    
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="project" id="projects_list" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($project->id); ?>"<?php if($leaseRentalAgreement->project_id == $project->id): ?> selected <?php endif; ?>><?php echo e($project->project_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label for="project" style="color: red" class="active">Project<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="project_unit" class="browser-default select2" id="project_units_list"
                                        required>
                                        <option value="">---Select---</option>
                                    </select>
                                    <label for="project_unit" style="color: red" class="active">Project Units<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="floor" class="browser-default select2" id="floor_list" required>
                                        <option value="">---Select Floor---</option>
                                        
                                    </select>
                                    <label for="floor" style="color: red" class="active">Floor<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="type" id="type_list" class="browser-default select2" required>
                                        <option value="">---Select Type---</option>
                                        
                                    </select>
                                    <label for="type" style="color: red" class="active">Type<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="type_area" id="type_area" data-parsley-type="number"
                                        required>
                                    <label for="type_area" id="type_area_lbl" style="color: red">Area<span
                                            class="red-star active">*</span></label>
                                </div>

                            </div>

                            <div class="row">

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="lessee" id="lessee" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        <?php $__currentLoopData = $lesseeData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lessee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($lessee->lessee_type == 'Individual'): ?>
                                                <option value="<?php echo e($lessee->id); ?>" <?php if($leaseRentalAgreement->lessee_id == $lessee->id): ?> selected <?php endif; ?>><?php echo e($lessee->individual_name); ?></option>
                                            <?php elseif($lessee->lessee_type == 'Company'): ?>
                                                <option value="<?php echo e($lessee->id); ?>" <?php if($leaseRentalAgreement->lessee_id == $lessee->id): ?> selected <?php endif; ?>><?php echo e($lessee->company_name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <label for="lessee" style="color: red" class="active">Lessee<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="date" name="agreement_date" id="agreement_date" value="<?php echo e($leaseRentalAgreement->agreement_date); ?>" required>
                                    <label for="agreement_date" style="color: red">Agreement Date<span
                                            class="red-star">*</span></label>
                                </div>
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="date" name="agreement_period_from" value="<?php echo e($leaseRentalAgreement->agreement_period_from); ?>" id="agreement_period_from" required>
                                    <label for="agreement_period_from" style="color: red">Agreement Period From<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="date" name="agreement_period_to" value="<?php echo e($leaseRentalAgreement->agreement_period_to); ?>" id="agreement_period_to" required>
                                    <label for="agreement_period_to" style="color: red">Agreement Period To<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="registration_charges" value="<?php echo e($leaseRentalAgreement->registration_charges); ?>" id="registration_charges"
                                        class="" required data-parsley-type="number" />
                                    <label for="registration_charges" style="color: red">Registration Charges<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="text" name="notice_period" id="notice_period" value="<?php echo e($leaseRentalAgreement->notice_period); ?>" class=""
                                        required data-parsley-type="integer" />
                                    <label for="notice_period" style="color: red">Notice Period (In months)<span
                                            class="red-star">*</span></label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="date" name="rent_start_date" id="rent_start_date" value="<?php echo e($leaseRentalAgreement->rent_start_date); ?>" required>
                                    <label for="rent_start_date" style="color: red">Rent Start Date<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <label>
                                        <input id="revenuew_sharing" type="checkbox" name="revenuew_sharing" />
                                        <span style="font-weight: bold; color: black">Revenue Sharing</span>
                                    </label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <label>
                                        <input id="fixedChargesInput" type="hidden" name="fixedChargesInput"/>
                                    </label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="button" class="btn" value="Generate">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col s12 l12">
                                    <ul class="tabs tab-demo z-depth-1">
                                        <li class="tab"><a href="#security_deposit">Security Deposit</a></li>
                                        <li class="tab"><a class="active" href="#fixed_charges">Fixed Charges</a>
                                        </li>
                                        <li class="tab"><a href="#variable_charges">Variable Charges</a></li>
                                    </ul>
                                    <div id="security_deposit">
                                        <div class="row">
                                            <div class="col s12 l12">
                                                <p>

                                                </p>
                                                <table id="security_deposit_table" class="responsive-table display"
                                                    style="width:100%">
                                                    <thead>
                                                        <tr>
                                                            <th>
                                                                Sl.No.
                                                            </th>
                                                            <th>
                                                                Select
                                                            </th>
                                                            <th>
                                                                Rate Item Name
                                                            </th>
                                                            <th>
                                                                Rate Calculation Method
                                                            </th>
                                                            <th>
                                                                Default Rate
                                                            </th>
                                                            
                                                            <th>
                                                                GST Rate
                                                            </th>
                                                            
                                                            <th>
                                                                TDS Rate
                                                            </th>
                                                            
                                                            <th>
                                                                Other Taxes
                                                            </th>
                                                            
                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>


                                    <div id="fixed_charges">
                                        <div class="row">
                                            <div class="col s12 l12">
                                                <p>

                                                </p>
                                                <table id="fixed_charges_table" class="responsive-table display"
                                                    style="width:100%">
                                                    <thead>
                                                        <tr>
                                                            <th>
                                                                Sl.No.
                                                            </th>
                                                            <th>
                                                                Select
                                                            </th>
                                                            <th>
                                                                Rate Item Name
                                                            </th>
                                                            <th>
                                                                Rate Calculation Method
                                                            </th>
                                                            <th>
                                                                Default Rate
                                                            </th>
                                                            
                                                            <th>
                                                                GST Rate
                                                            </th>
                                                            
                                                            <th>
                                                                TDS Rate
                                                            </th>
                                                            
                                                            <th>
                                                                Other Taxes
                                                            </th>
                                                            
                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>


                                    <div id="variable_charges">
                                        <div class="row">
                                            <div class="col s12 l12">
                                                <p>

                                                </p>
                                                <table id="variable_charges_table" class="responsive-table display"
                                                    style="width:100%">
                                                    <thead>
                                                        <tr>
                                                            <th>
                                                                Sl.No.
                                                            </th>
                                                            <th>
                                                                Select
                                                            </th>
                                                            <th>
                                                                Rate Item Name
                                                            </th>
                                                            <th>
                                                                Rate
                                                            </th>
                                                            
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input type="submit" class="btn" value="Save">
                                    <a href="<?php echo e(route('mall-software.lease_rental_agreement')); ?>" class="btn"
                                        type="btn">Cancel</a>

                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        $(document).ready(function() {
            $('#type_list').on('change', function() {
                var type_id = $(this).val();
                if (type_id !== '') {
                    $.ajax({
                        url: '<?php echo e(route('mall-software.lease_rental_agreement.type_area')); ?>', // Replace this with the actual URL to fetch type area
                        type: 'GET',
                        data: {
                            type_id: type_id
                        },
                        success: function(response) {
                            $("#type_area_lbl").addClass('active');
                            $('#type_area').val(response);
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText); // Log any errors to the console
                        }
                    });
                } else {
                    $('#type_area').val(''); // Clear the value if no type is selected
                }
            });



        });



        // $(function() {
        //     $('#security_deposit_table').DataTable();
        //     $('#fixed_charges_table').DataTable();
        //     $("#variable_charges_table").DataTable();
        // });
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
    <script>
        // Initialize Parsley.js on your form
        $(document).ready(function() {
            $('#formValidate').parsley();

            $('#mySelect').on('select2:select', function(e) {
                $(this).parsley().validate(); // Trigger Parsley validation after selecting a value
            });
        });
    </script>


    <script>
        $(document).ready(function() {
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });

            let security_deposit_table = $('#security_deposit_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "<?php echo e(route('mall-software.lease_rental_agreement.getSecurityDepositList')); ?>",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'checkbox',
                        name: 'checkbox'
                    },
                    {
                        data: 'rate_item_name',
                        name: 'rate_item_name'
                    },
                    {
                        data: 'calculation_method',
                        name: 'calculation_method'
                    },
                    {
                        data: 'default_rate',
                        name: 'default_rate'
                    },
                    // {
                    //     data: 'total',
                    //     name: 'total'
                    // },
                    {
                        data: 'gst_percentage',
                        name: 'gst_percentage'
                    },
                    // {
                    //     data: 'GST Amount',
                    //     name: 'GST Amount'
                    // },
                    {
                        data: 'tds_percentage',
                        name: 'tds_percentage'
                    },
                    // {
                    //     data: 'TDS Amount',
                    //     name: 'TDS Amount'
                    // },
                    {
                        data: 'Other Taxes',
                        name: 'Other Taxes'
                    },
                    // {
                    //     data: 'Net Amount',
                    //     name: 'Net Amount'
                    // },
                ],
                // "order": [
                //     [1, "desc"]
                // ],
                // "drawCallback": function(settings) {
                //     //alert( 'DataTables has redrawn the table' );
                //     $('.dropdown-trigger').dropdown();
                // },
                // lengthMenu: [
                //     [10, 25, 50, 100, -1],
                //     ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                // ],
            });



            let fixed_charges_table = $('#fixed_charges_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "<?php echo e(route('mall-software.lease_rental_agreement.getFixedChargesList')); ?>",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'checkbox',
                        name: 'checkbox'
                    },
                    {
                        data: 'rate_item_name',
                        name: 'rate_item_name'
                    },
                    {
                        data: 'calculation_method',
                        name: 'calculation_method'
                    },
                    {
                        data: 'default_rate',
                        name: 'default_rate'
                    },
                    // {
                    //     data: 'total',
                    //     name: 'total'
                    // },
                    {
                        data: 'gst_percentage',
                        name: 'gst_percentage'
                    },
                    // {
                    //     data: 'GST Amount',
                    //     name: 'GST Amount'
                    // },
                    {
                        data: 'tds_percentage',
                        name: 'tds_percentage'
                    },
                    // {
                    //     data: 'TDS Amount',
                    //     name: 'TDS Amount'
                    // },
                    {
                        data: 'Other Taxes',
                        name: 'Other Taxes'
                    },
                    // {
                    //     data: 'Net Amount',
                    //     name: 'Net Amount'
                    // },
                ],
                // "order": [
                //     [1, "desc"]
                // ],
                // "drawCallback": function(settings) {
                //     //alert( 'DataTables has redrawn the table' );
                //     $('.dropdown-trigger').dropdown();
                // },
                // lengthMenu: [
                //     [10, 25, 50, 100, -1],
                //     ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                // ],
            });


            let variable_charges_table = $('#variable_charges_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "<?php echo e(route('mall-software.lease_rental_agreement.getVariableChargesList')); ?>",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'checkbox',
                        name: 'checkbox'
                    },
                    {
                        data: 'rate_item_name',
                        name: 'rate_item_name'
                    },
                    {
                        data: 'default_rate',
                        name: 'default_rate'
                    },
                    // {
                    //     data: 'amount',
                    //     name: 'amount'
                    // },
                ],
                // "order": [
                //     [1, "desc"]
                // ],
                // "drawCallback": function(settings) {
                //     //alert( 'DataTables has redrawn the table' );
                //     $('.dropdown-trigger').dropdown();
                // },
                // lengthMenu: [
                //     [10, 25, 50, 100, -1],
                //     ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                // ],
            });


            $('#projects_list').on('change', function() {
                $('#project_units_list').empty();
                let project_id = $(this).val();
                if (project_id != "") {
                    $.ajax({
                        url: '<?php echo e(route('mall-software.lease_rental_agreement.getUnits')); ?>',
                        type: 'GET',
                        data: {
                            project_id: project_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose Unit</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .unit_name + '</option>';
                                });
                                $('#project_units_list').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#project_units_list').html('<option value="">Choose Unit</option>');
                }
            });

            $('#project_units_list').on('change', function() {
                $('#floor_list').empty();
                $('#type_list').empty();
                let unit_id = $(this).val();
                if (unit_id != "") {
                    $.ajax({
                        url: '<?php echo e(route('mall-software.lease_rental_agreement.getFloors')); ?>',
                        type: 'GET',
                        data: {
                            unit_id: unit_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose Floor</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .name + '</option>';
                                });
                                $('#floor_list').html(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#floor_list').html('<option value="">Choose Floor</option>');
                }

                if (unit_id != "") {
                    $.ajax({
                        url: '<?php echo e(route('mall-software.lease_rental_agreement.getTypes')); ?>',
                        type: 'GET',
                        data: {
                            unit_id: unit_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose Type</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .type + '</option>';
                                });
                                $('#type_list').html(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#type_list').html('<option value="">Choose Type</option>');
                }
            });
        });

        $(document).on('click', '.fixedCharges', function() {
            var fixedChargeId = $(this).data('id');
            if (fixedChargeId != null) {
                $('#fixedChargesInput').val(fixedChargeId);
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/loginhilitemall/public_html/hilite-mall-software/leads/resources/views/mall_software/lease_rental_agreement/edit.blade.php ENDPATH**/ ?>