/*!
 * PSPDFKit for Web 2024.5.1 (https://pspdfkit.com/web)
 *
 * Copyright (c) 2016-2024 PSPDFKit GmbH. All rights reserved.
 *
 * THIS SOURCE CODE AND ANY ACCOMPANYING DOCUMENTATION ARE PROTECTED BY INTERNATIONAL COPYRIGHT LAW
 * AND MAY NOT BE RESOLD OR REDISTRIBUTED. USAGE IS BOUND TO THE PSPDFKIT LICENSE AGREEMENT.
 * UNAUTHORIZED REPRODUCTION OR DISTRIBUTION IS SUBJECT TO CIVIL AND CRIMINAL PENALTIES.
 * This notice may not be removed from this file.
 *
 * PSPDFKit uses several open source third-party components: https://pspdfkit.com/acknowledgements/web/
 */
"use strict";(globalThis.webpackChunkPSPDFKit=globalThis.webpackChunkPSPDFKit||[]).push([[4267],{86528:(e,t,n)=>{n.d(t,{V:()=>c});var a=n(85728),i=n(35369),s=n(33427),o=n(11765),r=n(21853),l=n(65160);class c{constructor(e){this.ctx=e}renderTile(e,t,n,i,l,c){let d;c&&(d={annotations:c.annotations.filter(s.d).map(o.Hs).toJS().map((e=>({content:e}))),formFieldValues:c.formFieldValues.map(o.kr).toJS(),formFields:c.formFields.map(o.vD).toJS(),signatures:c.signatures||[],attachments:c.attachments});const u=a.f.Renderer.renderTile(this.ctx,e,t,n,{renderForPrinting:i,renderText:l,priority:t.width===n.width&&t.height===n.height?a.f.Priority.High:a.f.Priority.Normal},d).then((e=>(0,r.R9)({buffer:e.buffer,width:n.width,height:n.height,format:e.format}).then((e=>{if(null===e)throw new Error("Image handle is null");return e}))));return{promise:u.promise,cancel:u.cancel}}getTextLines(e){return a.f.Text.getTextForPage(this.ctx,e).then((t=>(0,l.TH)({textLines:t},e)))}getContentTree(e){return a.f.Text.getContentTreeForPage(this.ctx,e).then((t=>{let n=[],a=0,s=0;return n=t.reduce(((t,n)=>{let{nodes:i}=n;const o=(0,l.uv)(i,e,t.length,a,s);return a+=o.reduce(((e,t)=>{let{textLines:n}=t;return e+n.size}),0),s+=o.reduce(((e,t)=>{let{contentElements:n}=t;return e+n.size}),0),t.concat(o)}),[]),(0,i.aV)(n)}))}}},87460:(e,t,n)=>{n.d(t,{W:()=>d});var a=n(96156),i=n(35369),s=n(15359),o=n(45249),r=n(33427),l=n(60209),c=n(30006);class d{constructor(){(0,a.Z)(this,"attachmentsCache",(0,i.D5)()),(0,a.Z)(this,"cachedAPStreams",(0,i.D5)()),(0,a.Z)(this,"pageAPStreamsPromises",(0,i.D5)()),(0,a.Z)(this,"annotationAPStreamPromises",(0,i.D5)()),(0,a.Z)(this,"_cachedRenderedAnnotation",null),(0,a.Z)(this,"_objectURLs",{}),(0,a.Z)(this,"_makeEnqueuedRelease",((e,t)=>{if("IMG"===e?.element?.tagName){const n=e.element.src;if(!n)return;"number"==typeof this._objectURLs[n]?this._objectURLs[n]++:this._objectURLs[n]=1;const a=e.release;e.release=()=>{this._objectURLs[n]--,this._objectURLs[n]<=0&&(a?.(),this._cachedRenderedAnnotation?.index===t&&(this._cachedRenderedAnnotation=null),delete this._objectURLs[n])}}}))}getAnnotationFormFieldAndValue(e){const t=this.provider;(0,s.kG)(t instanceof t.constructor,"Backend can only use backend annotation provider");const n=e instanceof o.x_?t._readStateCallbacks?.getFormFieldByName(e.formFieldName):null;return{formField:n,formFieldValue:!n||n instanceof o.Yo?null:new o.KD({name:n.name,value:void 0!==n.formattedValue?n.formattedValue:"string"==typeof n.value?n.value:n.values})}}getAnnotationAvailableVariants(e){const t=this.provider;(0,s.kG)(t instanceof t.constructor,"Backend can only use backend annotation provider");return[...t._readStateCallbacks?.getAvailableVariants(e)||[],"normal"]}cachedRenderAnnotation(e,t,n,a,i){const o=this.provider;(0,s.kG)(o instanceof o.constructor,"Backend can only use backend annotation provider");const{formField:l,formFieldValue:c}=this.getAnnotationFormFieldAndValue(e);if(!(0,r._R)(e,l))return this.renderAnnotation(e,c,t,n,a,i);const d=this.getAnnotationAvailableVariants(e);let u=!1,m=()=>{u=!0};return{promise:new Promise((async(s,o)=>{const r=t=>{const n=this.annotationAPStreamPromises.get(e.id);n&&(this.annotationAPStreamPromises=this.annotationAPStreamPromises.delete(e.id),n(t))},l=this.annotationAPStreamPromises.get(e.id);this.annotationAPStreamPromises=this.annotationAPStreamPromises.set(e.id,s),l&&l(null);try{const o=this.pageAPStreamsPromises.get(e.pageIndex);if(!o){const t=new Promise((t=>{this.annotationAPStreamPromises=this.annotationAPStreamPromises.set(e.id,t)}));return void s(await t)}await o;const l=this.cachedAPStreams.get(e.pageIndex);if(l){const t=l?l.get(e.id):null;if(t)return void r(this.getAPStream(t,i))}const{promise:h,cancel:p}=this.renderAPStream(e,c,t,n,a,d,i);if(u)r(null);else if(m=p,d.length>1){const t=await Promise.all(h.map((e=>e.promise)));r(t[d.indexOf(i||"normal")]),t.some(Boolean)&&this.cacheAPStream(d.reduce(((e,n,a)=>t[a]?{...e,[n]:t[a]}:e),{}),e)}else{const t=await h,n=t?this.getAPStream(t,i):null;r(n),n&&this.cacheAPStream(t,e)}}catch(e){o(e)}})),cancel:m}}cacheAPStream(e,t){let n=this.cachedAPStreams.get(t.pageIndex);n||(this.cachedAPStreams=this.cachedAPStreams.set(t.pageIndex,(0,i.D5)()),n=this.cachedAPStreams.get(t.pageIndex)),this.cachedAPStreams=this.cachedAPStreams.setIn([t.pageIndex,t.id],e)}clearAllPageAPStreams(e){const t=this.cachedAPStreams.get(e);t&&(t.forEach((e=>{this.releaseAPStream(e)})),this.cachedAPStreams=this.cachedAPStreams.delete(e)),this.pageAPStreamsPromises=this.pageAPStreamsPromises.delete(e)}clearPageAPStreams(e,t){const n=this.cachedAPStreams.get(e);n&&(n.filter(((e,n)=>t.has(n))).forEach((e=>{this.releaseAPStream(e)})),this.cachedAPStreams=this.cachedAPStreams.updateIn([e],(e=>e.filter(((e,n)=>!t.has(n))))))}getAPStream(e,t){return e instanceof l.Z?e:e?.[t||"normal"]||null}renderAPStream(e,t,n,a,i,s,o){if(s.length>1){const o=s.map((s=>this.renderAnnotation(e,t,n,a,i,"normal"!==s?s:void 0)));return{promise:o,cancel:()=>{o.forEach((e=>{e.cancel()}))}}}return this.renderAnnotation(e,t,n,a,i,o)}releaseAPStream(e){e instanceof l.Z?e.release():Object.values(e).forEach((e=>{e.release()}))}isVisuallyIdenticalStampAnnotationCached(e){let{annotation:t,width:n,height:a}=e;const i=(0,r.et)(t);return!!this._cachedRenderedAnnotation&&(0,c.Gx)({annotation:t,annotationVisualPropertiesString:i,width:n,height:a,secondAnnotationVisualPropertiesString:this._cachedRenderedAnnotation.index,secondAnnotationWidth:this._cachedRenderedAnnotation.width,secondAnnotationHeight:this._cachedRenderedAnnotation.height})}cachedStampAnnotationDiscardablePromise(e){let{promise:t,resolve:n,reject:a}=e;(0,s.kG)(this._cachedRenderedAnnotation);const i=this._cachedRenderedAnnotation.index;return this._cachedRenderedAnnotation.APStreamPromise.then((e=>{let t;e&&(t=new l.Z(e.element.cloneNode(!0),e.release),this._makeEnqueuedRelease(t,i)),n(t)})).catch(a),{promise:t,cancel:()=>{}}}}},53392:(e,t,n)=>{n.d(t,{m:()=>ae,ZP:()=>ie,oc:()=>se,MO:()=>oe});var a=n(96156),i=n(35369),s=n(75472),o=n(15359),r=n(51679),l=n(34997),c=n(44276),d=n(85728),u=n(72110),m=n(69847),h=n(21853),p=n(7407),f=n(33427),g=n(87460),y=n(10983),b=n(84254),A=n(11765),S=n(67366),k=n(88133),P=n(56573),_=n(22284),F=n(24382);class w extends((0,i.WV)({alreadyLoadedPages:(0,i.D5)(),isLoaded:!1,isDestroyed:!1})){}const v={skippedPdfObjectIds:[],skippedPdfBookmarkIds:[],annotations:[],bookmarks:[],formFieldValues:[],formFields:[],attachments:{}};class C{constructor(e,t){(0,a.Z)(this,"_state",new w),(0,a.Z)(this,"_formFieldsLoadedPromise",null),(0,a.Z)(this,"_objectCreationPromises",(0,i.D5)()),(0,a.Z)(this,"_loadBookmarksPromise",null),(0,a.Z)(this,"_commentsLoadedPromise",null),(0,a.Z)(this,"canCreateBackendOrphanWidgets",!1),(0,a.Z)(this,"updateTabOrderTimeout",null),(0,a.Z)(this,"pagesTabOrderToUpdate",(0,i.l4)()),this._core=e,this._json=t?(0,o.H7)(t):null,this._setReadStateCallbacksPromise=new Promise((e=>{this._setReadStateCallbacksPromiseResolve=e}))}async load(){if(this._state=this._state.set("isLoaded",!0),!this._formFieldCallbacks&&await this._loadFormFieldValues(),!this._json)return this;await this._core.importInstantJSON({...v,...this._json}),(0,o.kG)(this._json);const{annotations:e,attachments:t}=this._json;if(this._isDestroyed()||!t||0===Object.entries(t).length)return this;if(e)for(let n=0;n<e.length;n++){let a=null;const i=e[n];if("imageAttachmentId"in i&&i.imageAttachmentId){const e=t?t[i.imageAttachmentId]:null;if(e)try{a=(0,P.Jc)(atob(e.binary),e.contentType),(0,o.kG)(this._annotationCallbacks),this._annotationCallbacks.createAttachment(i.imageAttachmentId,a)}catch(e){(0,o.um)(`Skipped attachment with id ${i.imageAttachmentId} from payload because an error occurred while converting the binary image to blob.`),(0,o.um)(e)}}}return this}destroy(){this._state=this._state.set("isDestroyed",!0),this._annotationCallbacks=null,this._readStateCallbacks=null,this._bookmarkCallbacks=null,this._formFieldCallbacks=null,this._formFieldValueCallbacks=null,this._commentCallbacks=null}setReadStateCallbacks(e){this._readStateCallbacks=e,this._setReadStateCallbacksPromiseResolve?.()}setAnnotationCallbacks(e){this._annotationCallbacks=e}setBookmarkCallbacks(e){this._bookmarkCallbacks=e}setFormFieldCallbacks(e){this._formFieldCallbacks=e}setFormFieldValueCallbacks(e){this._formFieldValueCallbacks=e}setCommentCallbacks(e){this._commentCallbacks=e}createComment(e,t,n){return this._core.applyComments(t.map((e=>D(e,n))).toArray())}updateComment(e,t,n){return this._core.applyComments(t.map((e=>D(e,n))).toArray())}deleteComment(e,t,n){return this._core.applyComments(t.map((e=>D(e,n))).toArray())}async loadComments(){return this._commentsLoadedPromise||(this._commentsLoadedPromise=this._loadComments()),this._commentsLoadedPromise}async _loadComments(){this._verifyLoaded();const e=await this._core.getComments()??[],t=(0,i.aV)(e.map((e=>{let t;return t=e.pdfObjectId?e.id||e.pdfObjectId?.toString():(0,f.xc)(),(0,A.Mu)(t,e)})));await Promise.all(t.map((e=>"number"==typeof e.pageIndex&&this.loadAnnotationsForPageIndex(e.pageIndex))).filter(Boolean).toArray()),this._commentCallbacks?.createComments(t,F.y),this._commentsLoadedPromise=Promise.resolve()}async updateTabOrder(e){this.pagesTabOrderToUpdate=this.pagesTabOrderToUpdate.add(e),this.updateTabOrderTimeout&&clearTimeout(this.updateTabOrderTimeout),this.updateTabOrderTimeout=setTimeout((async()=>{const e=this.pagesTabOrderToUpdate.toArray();if(this.pagesTabOrderToUpdate=(0,i.l4)(),this._isDestroyed())return;const t=await Promise.all(e.map((e=>this._core.getTabOrder(e))));this._isDestroyed()||((0,o.kG)(this._annotationCallbacks),(0,S.dC)((()=>{e.forEach(((e,n)=>{this._annotationCallbacks?.setPageTabOrder(e,t[n])}))})))}),1e3)}async setTabOrder(e,t){return this._core.setTabOrder(e,t)}async createAnnotation(e,t){this._verifyLoaded();const n=t.find(((t,n)=>((0,o.kG)("imageAttachmentId"in e,"Annotation must have imageAttachmentId."),n===e.imageAttachmentId))),a=await this._core.createAnnotation((0,A.Hs)(e),n?n.data:null);"number"!=typeof a||"number"!=typeof e.pdfObjectId||e.pdfObjectId===a||this._isDestroyed()||((0,o.kG)(this._annotationCallbacks),this._annotationCallbacks.updateAnnotations((0,i.aV)([e.set("pdfObjectId",a)]))),await this.updateTabOrder(e.pageIndex)}async updateAnnotation(e){this._verifyLoaded(),await this._core.updateAnnotation((0,A.Hs)(e)),await this.updateTabOrder(e.pageIndex)}deleteAnnotation(e){return this._verifyLoaded(),this._core.deleteAnnotation((0,A.Hs)(e))}createBookmark(e){return this._verifyLoaded(),this._core.createBookmark((0,k.a)(e))}updateBookmark(e){return this._verifyLoaded(),this._core.updateBookmark((0,k.a)(e))}deleteBookmark(e){return this._verifyLoaded(),this._core.deleteBookmark(e)}createFormField(e){this._verifyLoaded(),(0,o.kG)(this._readStateCallbacks);const t=this._readStateCallbacks.getFormFieldWidgets(e);return this._core.createFormField((0,A.vD)(e),t.map((e=>(0,A.Hs)(e))).toArray()).then((async e=>{(0,S.dC)((()=>{e.forEach(((e,n)=>{const a=t.get(n);(0,o.kG)(a),(0,o.kG)(this._annotationCallbacks),"number"!=typeof e||"number"!=typeof a.pdfObjectId||a.pdfObjectId===e||this._isDestroyed()||this._annotationCallbacks.updateAnnotations((0,i.aV)([a.set("pdfObjectId",e)]))}))}))}))}updateFormField(e){this._verifyLoaded(),(0,o.kG)(this._readStateCallbacks);const t=this._readStateCallbacks.getFormFieldWidgets(e);return this._core.updateFormField((0,A.vD)(e),t.map((e=>(0,A.Hs)(e))).toArray())}deleteFormField(e){return this._verifyLoaded(),this._core.deleteFormField((0,A.vD)(e))}loadFormFields(){return this._formFieldsLoadedPromise||(this._formFieldsLoadedPromise=this._loadFormFields()),this._formFieldsLoadedPromise}async _loadFormFields(){this._verifyLoaded();const e=await this._core.readFormJSONObjects();if(this._isDestroyed())return;let t=(0,i.aV)(),n=(0,i.aV)().withMutations((n=>{e.forEach((e=>{const{formField:a,widgets:i,value:s}=e;try{let e;e=a.pdfObjectId?a.pdfObjectId.toString():(0,f.xc)();const r=(0,A.IN)(e,a);(0,o.kG)(this._readStateCallbacks),this._readStateCallbacks.isFormFieldInState(r.name)||n.push(r.set("value",s)),i.forEach((e=>{let n;n=e.pdfObjectId?e.id||e.pdfObjectId.toString():(0,f.xc)(),(0,o.kG)(this._readStateCallbacks),t=t.push((0,A.vH)(n,e))}))}catch(e){(0,o.um)(`Skipped creating form field #${a.pdfObjectId} from payload because an error occurred while deserializing.`),(0,o.um)(e)}}))}));const a={},s={};t.forEach((e=>{s[e.id]||(s[e.id]=[]),s[e.id].push(e.pdfObjectId)})),t=t.map((e=>{if(s[e.id].filter((t=>t!==e.pdfObjectId)).length>0&&e.pdfObjectId?.toString()!==e.id||this._readStateCallbacks?.isAnnotationInState(e.id)){const t=(0,f.xc)();return a[e.formFieldName]?a[e.formFieldName].push({[e.id]:t}):a[e.formFieldName]=[{[e.id]:t}],n=n.map((n=>n.name===e.formFieldName?n.update("annotationIds",(n=>n?.map((n=>n===e.id?t:n)))):n)),e.set("id",t)}return e})),Object.keys(a).forEach((e=>{const a=n.find((t=>t.name===e));(0,o.kG)(a);const i=t.filter((t=>t.formFieldName===e)).toArray().map((e=>(0,A.Hs)(e)));this._core.updateFormField((0,A.vD)(a),i)})),n.size>0&&!this._isDestroyed()&&((0,o.kG)(this._formFieldCallbacks),this._formFieldCallbacks.createFormFields(n,F.y)),await this._loadFormFieldValues(),t.size>0&&!this._isDestroyed()&&((0,o.kG)(this._annotationCallbacks),this._annotationCallbacks.createAnnotations(t,(0,i.D5)(),F.y)),this._formFieldsLoadedPromise=Promise.resolve()}createFormFieldValue(e){return this._verifyLoaded(),this.setFormFieldValue(e)}setFormFieldValue(e){return this._verifyLoaded(),this._core.setFormFieldValue((0,A.kr)(e))}deleteFormFieldValue(e){return this._verifyLoaded(),this._core.deleteFormFieldValue(e.replace("form-field-value/",""))}loadAnnotationsForPageIndex(e){const t=this._state.alreadyLoadedPages.get(e);if(t)return t;const n=this._loadAnnotationsForPageIndex(e);return this._state=this._state.setIn(["alreadyLoadedPages",e],n),n}async _loadAnnotationsForPageIndex(e){this._verifyLoaded();const[t,n]=await Promise.all([this._core.annotationsForPageIndex(e),this._core.getTabOrder(e)]);if(this._isDestroyed())return;const a=[],s=[],r=t.map((e=>{let{rollover:t,down:n,...i}=e;return t&&"number"==typeof i.pdfObjectId&&a.push(i.pdfObjectId),n&&"number"==typeof i.pdfObjectId&&s.push(i.pdfObjectId),i})).filter((e=>"number"==typeof e.pageIndex));this._formFieldCallbacks&&await this.loadFormFields();const l=(0,i.aV)().withMutations((e=>{r.filter((e=>!e.id||this._readStateCallbacks&&!this._readStateCallbacks.isAnnotationInState(e.id))).forEach((t=>{t.pdfObjectId;try{let n;n=function(e){return"pspdfkit/link"===e.type&&0===e.pdfObjectId}(t)?t.id||(0,f.xc)():t.id||t.pdfObjectId.toString(),(e.some((e=>e.id===n))||this._readStateCallbacks?.isAnnotationInState(n))&&(n=(0,f.xc)(),t.id=n,this._core.updateAnnotation(t));const a=(0,A.vH)(n,t);e.push(a)}catch(e){(0,o.um)(`Skipped creating annotation #${t.pdfObjectId} from payload because an error occurred while deserializing.`),(0,o.um)(e)}}))}));(0,S.dC)((()=>{(0,o.kG)(this._annotationCallbacks),l.size>0&&this._annotationCallbacks.createAnnotations(l,(0,i.D5)(),F.y),this._annotationCallbacks.setPageTabOrder(e,n),a.length>0&&this._annotationCallbacks.addAnnotationVariants("rollover",a),s.length>0&&this._annotationCallbacks.addAnnotationVariants("down",s)})),this._state=this._state.setIn(["alreadyLoadedPages",e],Promise.resolve())}async _loadFormFieldValues(){this._verifyLoaded();const e=await this._core.getFormValues();if(this._isDestroyed())return;const t=(0,i.aV)().withMutations((t=>{e.forEach((e=>{try{t.push((0,A.u9)(e))}catch(t){(0,o.um)(`Skipped creating form field value #${e.pdfObjectId} from payload because an error occurred while deserializing.`),(0,o.um)(t)}}))}));t.size>0&&!this._isDestroyed()&&((0,o.kG)(this._formFieldValueCallbacks),this._formFieldValueCallbacks.setFormFieldValues(t))}async loadBookmarks(){this._verifyLoaded();const e=await this._core.getBookmarks();if(this._isDestroyed())return;const t=(0,i.aV)().withMutations((t=>{e.forEach((e=>{let n;n=e.id?e.id:e.pdfBookmarkId?e.pdfBookmarkId:(0,_.A)();try{t.push((0,k.i)(n,e))}catch(e){(0,o.um)(`Skipped creating bookmark #${n} from payload because an error occurred while deserializing.`),(0,o.um)(e)}}))}));t.size>0&&!this._isDestroyed()&&((0,o.kG)(this._bookmarkCallbacks),this._bookmarkCallbacks.createBookmarks(t,F.y))}_verifyLoaded(){(0,o.kG)(this._state.isLoaded,"StandaloneProvider not properly initialized.")}_isDestroyed(){return this._state.isDestroyed}async syncChanges(){}}function D(e,t){(0,o.kG)(e.rootId,"A new comment must have `rootId` present");const n=t.get(e.rootId);return(0,o.kG)(n,"An annotation must be present linked to the comment to create"),(0,A.jA)(e,n.pdfObjectId?.toString()===n.id?parseInt(e.rootId):e.rootId)}class I{constructor(e,t){this.identifier=e,this.callback=t}request(){return this.callback()}}var x=n(78025),O=n(20063);class R extends(i.WV({baseUrl:null,baseCoreUrl:null,baseProcessorEngineUrl:null,licenseKey:null,document:null,backendPermissions:new x.Z,documentResponse:null,disableWebAssemblyStreaming:!1,enableAutomaticLinkExtraction:!1,overrideMemoryLimit:null,features:(0,i.aV)(),signatureFeatureAvailability:O.H.NONE,documentHandle:null,trustedCAsCallback:null,signaturesInfoPromise:null,customFonts:null,fontSubstitutions:null,forceLegacySignaturesFeature:!1,forceAnnotationsRender:!1,appName:null,lazyLoadedPages:null,productId:null,processorEngine:null,dynamicFonts:null,inlineWorkers:!0})){}var T=n(43069),L=n(36691),E=n(88265),B=n(94732),G=n(94809),U=n(98492),V=n(96650),N=n(87856),j=n(2282),M=n(67055),W=n(45249),K=n(44550),z=n(33383),H=n(74311),Z=n(74110),J=n(15650),q=n(33907),$=n(44077),X=n(86528),Y=n(46364);function Q(e){return"string"==typeof e?.serialNumber&&e.body instanceof ArrayBuffer}function ee(e){return e?.pkcs7 instanceof ArrayBuffer&&(!("ocspResponses"in e)||Array.isArray(e.ocspResponses)&&e.ocspResponses.every((e=>Q(e))))}function te(e){if(!e)return!1;const{signedData:t,timestampResponse:n,ocspResponses:a}=e;if(!(t instanceof ArrayBuffer))return!1;if(n&&!(n instanceof ArrayBuffer))return!1;if(a){if(!Array.isArray(a))return!1;if(!a.every((e=>Q(e))))return!1}return!0}let ne;ne=n(75472).AO;const ae=new s.L7(ne);class ie extends g.W{constructor(e){super(),(0,a.Z)(this,"type","STANDALONE"),(0,a.Z)(this,"_XFDF",null),oe(e);const{baseUrl:t,baseCoreUrl:n,baseProcessorEngineUrl:i,instantJSON:s,XFDF:o,enableAutomaticLinkExtraction:l,overrideMemoryLimit:c,trustedCAsCallback:u,electronAppName:m,appName:h,isSharePoint:p,isSalesforce:f,productId:g,processorEngine:b,dynamicFonts:A,inlineWorkers:S}=e;"string"==typeof o&&(this._XFDF={source:o,keepCurrentAnnotations:!0===e.XFDFKeepCurrentAnnotations,ignorePageRotation:!0===e.XFDFIgnorePageRotation}),s&&s.annotations&&(s.annotations=s.annotations.map((e=>(e.id=e.id?.toString(),e)))),this._instantJSON=s,"function"==typeof u&&(this._trustedCAsCallback=u);const{disableWebAssemblyStreaming:k,customFonts:P,fontSubstitutions:_}=e,{standaloneInstancesPoolSize:F}=e;void 0!==F&&(ae.size=F);const w=!!e.electronicSignatures&&Boolean(e.electronicSignatures.forceLegacySignaturesFeature);let v=g||null;!p&&!f||v||(v=p?z.x.SharePoint:z.x.Salesforce),this._state=new R(se({baseUrl:t,baseCoreUrl:n,baseProcessorEngineUrl:i,licenseKey:e.licenseKey,document:e.document,disableWebAssemblyStreaming:k,enableAutomaticLinkExtraction:l,overrideMemoryLimit:c,documentHandle:"0",customFonts:P,fontSubstitutions:_,forceLegacySignaturesFeature:w,appName:h||m,productId:v,processorEngine:b||J.l.fasterProcessing,dynamicFonts:A,inlineWorkers:S})),this._requestQueue=new r.g(y.gZ);const{object:D,checkIn:I}=ae.checkOut();this.client=D,this.checkIn=I,this.corePDFBridge=new X.V(d.f.createWASMContext(this.client));const x=s?{annotations:s.annotations||[],formFields:s.formFields||[],formFieldValues:s.formFieldValues||[],skippedPdfObjectIds:s.skippedPdfObjectIds||[],skippedPdfFormFieldIds:s.skippedPdfFormFieldIds||[],attachments:s.attachments||{},bookmarks:s.bookmarks||[],skippedPdfBookmarkIds:s.skippedPdfBookmarkIds||[],comments:s.comments||void 0,skippedComments:s.skippedComments||void 0,format:s.format,...s.pdfId?{pdfId:s.pdfId}:null}:null;this.provider=new C(this.client,x)}isUsingInstantProvider(){return!1}hasClientsPresence(){return!1}async load(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this._isPDFJavaScriptEnabled=e.isPDFJavaScriptEnabled,{features:this._state.features,signatureFeatureAvailability:this._state.signatureFeatureAvailability,hasPassword:!!e.password,allowedTileScales:"all"}}destroy(){this.provider&&this.provider.destroy(),this._requestQueue&&this._requestQueue.destroy(),this.checkIn()}async documentInfo(){return this._state.documentResponse}async lazyLoadPages(){if(!this._state.lazyLoadedPages){const e=await this.client.getAllPageInfos(this._state.documentResponse.pageCount);this._state=this._state.set("lazyLoadedPages",e)}return this._state.lazyLoadedPages}getDocumentHandle(){return this._state.documentHandle}getFormJSON(){return this.client.getFormJSON()}permissions(){return Promise.resolve(this._state.backendPermissions)}textForPageIndex(e){return this.corePDFBridge.getTextLines(e)}getContentTreeForPageIndex(e){return this.corePDFBridge.getContentTree(e)}getTextFromRects(e,t){return this.client.getTextFromRects(e,t.toJS())}getAvailableFontFaces(e){return this.client.getAvailableFontFaces(e)}async getSuggestedLineHeightFactor(e){return"number"!=typeof e.pdfObjectId?1:"number"!=typeof e.pageIndex?((0,o.ZK)("Annotation must have a pageIndex."),1):(e.lineHeightFactor&&(0,o.ZK)(`Annotation ${e.id} already has a line height factor.`),this.client.getSuggestedLineHeightFactor(e.pdfObjectId,e.pageIndex))}async getClosestSnapPoint(e){const t=await this.client.getClosestSnapPoint(e.x,e.y);return t&&"number"==typeof t[0]&&"number"==typeof t[1]?new $.E9({x:t[0],y:t[1]}):e}configureSnapper(e){return this.client.configureSnapper(e)}renderAnnotation(e,t,n,a,i,s){if(0===Math.floor(a)||0===Math.floor(i))return{promise:Promise.resolve(void 0),cancel:()=>{}};const o=(0,Y.d6)();if(e instanceof W.GI){if(this.isVisuallyIdenticalStampAnnotationCached({annotation:e,width:a,height:i}))return this.cachedStampAnnotationDiscardablePromise(o);(0,f.eD)(e)||(this._cachedRenderedAnnotation={index:(0,f.et)(e),width:a,height:i,APStreamPromise:o.promise})}const r=e.id,l=new I(r,(()=>this.client.renderAnnotation((0,A.Hs)(e),n,a,i,(0,N.zP)(),s).then((e=>e?"string"==typeof e?(0,h.ar)(e):(0,h.R9)({buffer:e,width:a,height:i}):Promise.resolve(null))).then((t=>(e instanceof W.GI&&this._makeEnqueuedRelease(t,(0,f.et)(e)),o.resolve(t),t)))));return this._requestQueue.enqueue(l,!1)}async getMeasurementSnappingPoints(e){return this.client.getMeasurementSnappingPoints(e)}async getSecondaryMeasurementUnit(){return await this.client.getSecondaryMeasurementUnit()}async setSecondaryMeasurementUnit(e){return await this.client.setSecondaryMeasurementUnit(e)}async compareDocuments(e,t){const n={originalDocument:e.originalDocument,changedDocument:e.changedDocument,comparisonOperation:(0,m.j)(t)};return await this.client.compareDocuments(n)}async renderPageAnnotations(e,t,n){const a=this.provider,i=[],s=[],o=t.some((e=>e instanceof W.x_));o&&await a._setReadStateCallbacksPromise;const r=t.filter((e=>{const t=(o?a._readStateCallbacks.getAnnotationWithFormField(e.id):null)?.formField,n=(0,f._R)(e,t);if(n&&t){i.find((e=>e.name===t.name))||(i.push((0,A.kr)((0,T.CH)(t))),s.push(t))}return n}));function l(e,t){if(e?.formFieldName){const n=s.find((t=>t.name===e.formFieldName)),a=t.find((t=>t.name===e.formFieldName));if(!(0,T.BT)(n,a))return!1}return!0}const c=new Promise(((t,i)=>{const o=r.filter((e=>0!==Math.floor(e.boundingBox.width*n)&&0!==Math.floor(e.boundingBox.height*n)));this.client.renderPageAnnotations(e,o.map((e=>e.pdfObjectId)).toArray(),o.map((e=>e.boundingBox.width*n)).toArray(),o.map((e=>e.boundingBox.height*n)).toArray(),(0,N.zP)()).then((e=>{const i=s.map((e=>a._readStateCallbacks?.getFormFieldByName(e.name))).filter(Boolean),r=e.map(((e,t)=>{const a=o.get(t);return l(a,i)&&a&&e?"string"==typeof e?(0,h.ar)(e):(0,h.R9)({buffer:e,width:a.boundingBox.width*n,height:a.boundingBox.height*n}):Promise.resolve(null)}));Promise.all(r).then((e=>{const i=s.map((e=>a._readStateCallbacks?.getFormFieldByName(e.name))).filter(Boolean);e.forEach(((e,t)=>{const a=o.get(t);if(a){const{formFieldValue:t}=this.getAnnotationFormFieldAndValue(a),s=this.getAnnotationAvailableVariants(a),o=this.annotationAPStreamPromises.get(a.id),r=l(a,i);if(o&&(this.annotationAPStreamPromises=this.annotationAPStreamPromises.delete(a.id),o(r?e:null)),s.length>1){const i={normal:e};e&&r&&this.cacheAPStream(i,a);const{promise:o}=this.renderAPStream(a,t,null,a.boundingBox.width*n,a.boundingBox.height*n,s);Promise.all(o.map((e=>e.promise))).then((e=>{e.some(Boolean)&&s.forEach(((t,n)=>{"normal"!==t&&e[n]&&(i[t]=e[n])}))}))}else e&&r&&this.cacheAPStream(e,a)}})),t()}))})).catch(i)}));return this.pageAPStreamsPromises=this.pageAPStreamsPromises.set(e,c),c}renderDetachedAnnotation(e,t,n,a){if(e.id)throw new o.p2(`Detached annotations should not have an \`id\`: ${e.id}`);const i=(0,Y.d6)();if(e instanceof W.GI){if(this.isVisuallyIdenticalStampAnnotationCached({annotation:e,width:n,height:a}))return this.cachedStampAnnotationDiscardablePromise(i);(0,f.eD)(e)||(this._cachedRenderedAnnotation={index:(0,f.et)(e),width:n,height:a,APStreamPromise:i.promise})}const s=(0,l.SK)(),r=new I(s,(()=>this.client.renderDetachedAnnotation((0,A.Hs)(e),t,n,a,(0,N.zP)()).then((e=>e?(0,h.R9)({buffer:e,width:n,height:a}):Promise.resolve(null))).then((t=>(e instanceof W.GI&&this._makeEnqueuedRelease(t,(0,f.et)(e)),i.resolve(t),t))))),{promise:c,cancel:d}=this._requestQueue.enqueue(r,!1);return{promise:c,cancel:d}}async getAttachment(e){const[t,n]=await this.client.getAttachment(e);return new Blob([t],{type:n})}async parseXFDF(e,t){const{errors:n,formFieldValues:a,annotations:s}=await this.client.parseXFDF(e,t);return{errors:n?.map((e=>({errorMessage:e.error_message,type:e.type}))),formFieldValues:a?.reduce(((e,t)=>(e[t.fqdn]=t.values,e)),{}),annotations:(0,i.aV)(s?.map((e=>(0,A.vH)((0,f.xc)(),e)))||[])}}async search(e,t,n,a){let i=arguments.length>4&&void 0!==arguments[4]&&arguments[4],s=arguments.length>5&&void 0!==arguments[5]?arguments[5]:V.S.TEXT;const o=await this.client.search(e,t,n,a,s);return(0,b.E)(o.filter((e=>i||!e.isAnnotation)))}async searchAndRedact(e,t,n){const{totalPages:a}=n,s=await this.client.search(e,0,a,t.caseSensitive,t.searchType);return(0,i.aV)(s.filter((e=>t.searchInAnnotations||!e.isAnnotation)).map((e=>{const a=e.isAnnotation?[e.annotationRect]:e.rectsOnPage,s=(0,i.aV)(a).map((e=>((0,o.kG)(e),(0,U.k)(e))));return new B.Z({...(0,f.lx)(n),...t.annotationPreset,pageIndex:e.pageIndex,rects:s,boundingBox:L.Z.union(s)})})))}async exportPDF(){let{flatten:e=!1,incremental:t,saveForPrinting:n=!1,format:a="pdf",excludeAnnotations:i=!1,preserveInstantJSONChanges:s=!0,permissions:r,outputFormat:l=!1,flattenElectronicSignatures:c=e}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},d=arguments.length>1?arguments[1]:void 0;if(e&&!c)throw new o.p2("Cannot set `flattenElectronicSignatures` to `false` when `flatten` is set to `true`.");if(l&&"boolean"!=typeof l&&l.conformance&&(0,o.kG)(l.conformance&&Object.values(H.w).includes(l.conformance),"The supplied PDF/A Conformance type is not valid. Valid Conformance should be one of the following options PSPDFKit.Conformance."+Object.keys(H.w).join(", PSPDFKit.Conformance.")),void 0===t)if(this._state.features.includes(K.q.DIGITAL_SIGNATURES)){const e=await this.getSignaturesInfo();t=!n&&Boolean("not_signed"!==e.status)}else t=!1;return this.client.exportFile(e,t,n,a,i,s,r,d).then((async e=>{let[t,n]=e;if(t.mimeType=n.mimeType,t.extension=n.extension,l){const e="boolean"!=typeof l&&l.conformance?l.conformance:H.w.PDFA_2B;let n;try{return n=await this._setupGdPictureClient(),await n.toPdf(t,e)}finally{n?.destroy(),(0,q.Nt)(null)}}return t}))}async exportOffice(e){let t,{format:n}=e;try{const[e]=await this.client.exportFile(!1,!1,!1,"pdf",!1,!0);return t=await this._setupGdPictureClient(),await t.toOffice(e,n)}catch(e){throw new o.p2(`Exporting to ${n} failed: ${e.message}.`)}finally{t?.destroy(),(0,q.Nt)(null)}}async _setupGdPictureClient(){let e=(0,q.xE)();return e||(e=(0,q.Un)({baseUrl:this._state.baseProcessorEngineUrl,mainThreadOrigin:this._state.appName||(0,u.$u)()||window.location.origin,licenseKey:this._state.licenseKey,processorEngine:this._state.processorEngine,customFonts:this._state.customFonts,dynamicFonts:this._state.dynamicFonts,fontSubstitutions:this._state.fontSubstitutions}),(0,q.Nt)(e)),e}exportXFDF(e){return this.client.exportXFDF(e)}exportInstantJSON(e){return this.client.exportInstantJSON(e)}getPDFURL(){let{includeComments:e=!0,saveForPrinting:t,excludeAnnotations:n}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.generatePDFObjectURL({includeComments:e,saveForPrinting:t,excludeAnnotations:n})}generatePDFObjectURL(){let e,{includeComments:t=!0,saveForPrinting:n,excludeAnnotations:a=!1}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},i=!1;return{promise:new Promise((s=>{this.exportPDF({flatten:!0,includeComments:t,saveForPrinting:n,excludeAnnotations:a}).then((t=>{if(i)return;const n=new Blob([t],{type:t.mimeType});e=window.URL.createObjectURL(n),s(e)}))})),revoke:()=>{e&&window.URL.revokeObjectURL(e),i=!0}}}async getDocumentOutline(){const e=await this.client.getDocumentOutline();return(0,i.aV)(e.map(p.i))}async setDocumentOutline(e){return this.client.setDocumentOutline(e.map(p.a).toArray())}async getPageGlyphs(e){const t=await this.client.getPageGlyphs(e);return(0,A.Vl)(t)}async onKeystrokeEvent(e){return await this.client.onKeystrokeEvent(e)}async evalFormValuesActions(e){return this.client.evalFormValuesActions(e.map(A.kr).toJS())}async evalScript(e,t,n){return this.client.evalScript(e,t,n)}async setFormJSONUpdateBatchMode(e){return this.client.setFormJSONUpdateBatchMode(e)}async getMeasurementScales(){return(await this.client.getMeasurementScales())?.measurementContentFormats}async addMeasurementScale(e){return await this.client.addMeasurementScale(e)}async removeMeasurementScale(e){return await this.client.removeMeasurementScale(e)}async getAnnotationsByScale(e){return await this.client.getAnnotationsByScale(e)}async applyOperationsAndReload(e){try{const{processedOperations:t,operationsDocuments:n}=await re(e);await this.client.applyOperations(t,n)}catch(e){throw new o.p2(`Applying operations failed: ${e}`)}return this.provider._state=this.provider._state.set("alreadyLoadedPages",(0,i.D5)()),this.reloadDocument()}async applyRedactionsAndReload(){try{await this.client.applyRedactions()}catch(e){throw new o.p2(`Applying redactions failed: ${e}`)}return this.reloadDocument()}async reloadDocument(){try{this.provider?.destroy(),this.provider=new C(this.client,null),this._state=this._state.set("lazyLoadedPages",null);const e=await this.client.reloadDocument();return this._state=this._state.set("documentResponse",e).set("documentHandle",(parseInt(this._state.documentHandle)+1).toString()).set("signaturesInfoPromise",null),{features:this._state.features,signatureFeatureAvailability:this._state.signatureFeatureAvailability,hasPassword:!1,allowedTileScales:"all"}}catch(e){throw new o.p2(`Reloading failed: ${e}`)}}async getEmbeddedFiles(){const e=await this.client.getEmbeddedFilesList();return(0,i.aV)(e.map((e=>{let{id:t,...n}=e;return(0,M.i)(t,n,!0)})))}async exportPDFWithOperations(e){try{const{processedOperations:t,operationsDocuments:n}=await re(e);return this.client.exportPDFWithOperations(t,n)}catch(e){throw new o.p2(`Exporting PDF with operations failed: ${e}`)}}async setSignaturesLTV(e){try{const t=(e??[]).map((e=>e instanceof ArrayBuffer?c.DS.fromUint8Array(new Uint8Array(e)):c.DS.encode(e))),n=await this.getRevocationResponses(t);if((await this.client.setSignaturesLTV(n).then((e=>(0,A.rS)(e)))).signatures?.find((e=>e.certificateChainValidationStatus===Z.wk.ok_but_could_not_check_revocation)))throw"Could not set LTV for all signatures. Check that the OCSP response is valid.";return this._state=this._state.set("signaturesInfoPromise",null),this.getSignaturesInfo()}catch(e){throw new o.p2(`Setting signatures LTV failed: ${e}`)}}getSignaturesInfo(){try{if(this._state.signaturesInfoPromise)return this._state.signaturesInfoPromise;const e=this.client.getSignaturesInfo().then((e=>(0,A.rS)(e)));return this._state=this._state.set("signaturesInfoPromise",e),e}catch(e){throw new o.p2(`Getting document signatures info: ${e}`)}}async refreshSignaturesInfo(){this._state=this._state.set("signaturesInfoPromise",null)}async loadCertificates(e){return this.client.loadCertificates(e)}async getRevocationResponses(e){const t=await this.client.getRevocationRequests(e);return await Promise.all(t.map((async e=>{let{method:t,url:n,content_type:a,request_data:i,token:s}=e;try{const e=await fetch(n,{method:t,headers:{"Content-Type":a??"application/ocsp-request"},body:c.DS.toUint8Array(i).buffer}),o=await e.arrayBuffer();return{response_code:e.status,body:c.DS.fromUint8Array(new Uint8Array(o)),token:s}}catch(e){return{response_code:0,body:"",token:s,error_message:e.message}}})))}async signDocumentAndReload(e,t){(0,o.kG)(void 0===t||"function"==typeof t,"On a Standalone deployment, `twoStepSignatureCallbackOrSigningServiceData` must be a function if provided.");const n=e?.signingData?.certificates;(0,o.kG)(!e?.signingData?.signatureType||e?.signingData?.signatureType===Z.BG.CMS||Array.isArray(n)&&n.length>0,"For signatures of type `PSPDFKit.SignatureType.CAdES` an `Array` of certificates must be provided in `signaturePreparationData.signingData.certificates`."),(0,o.kG)(!e?.signingData?.timestamp||"string"==typeof e?.signingData?.timestamp?.url,"The `url` property of `signingData.timestamp` must be a string."),(0,o.kG)(!e?.signingData?.timestamp||!e?.signingData?.timestamp?.password||"string"==typeof e?.signingData?.timestamp?.password,"The `password` property of `signingData.timestamp` must be a string."),(0,o.kG)(!e?.signingData?.timestamp||!e?.signingData?.timestamp?.username||"string"==typeof e?.signingData?.timestamp?.username,"The `username` property of `signingData.timestamp` must be a string."),(0,o.kG)(void 0===e?.signingData?.ltv||"boolean"==typeof e?.signingData?.ltv,"The `ltv` property of `signingData` must be a boolean if set.");const a={signatureType:e?.signingData?.signatureType||(Array.isArray(n)&&n.length>0?Z.BG.CAdES:Z.BG.CMS),...e?.signingData?.certificates&&{certificates:e.signingData.certificates.map((e=>e instanceof ArrayBuffer?c.DS.fromUint8Array(new Uint8Array(e)):c.DS.encode(e)))},...e?.placeholderSize?{estimatedSize:e.placeholderSize}:null};try{const{hash:n,signatureFormFieldName:i,file:s,fileContents:r,dataToBeSigned:l}=await this.client.prepareSign((0,A._L)(a),e?.signatureMetadata?(0,A._D)(e.signatureMetadata):null,Boolean(e?.flatten),e?.formFieldName,(0,A.eE)(e?.position),await(0,A.sr)(e?.appearance)),d=function(e){const t=e.trim(),n=t.length/2,a=new Uint8Array(n);for(let e=0;e<n;e++)a[e]=parseInt(t.substr(2*e,2),16);return a}(l);let u,m,h;if(t){try{u=await t({hash:n,fileContents:r,dataToBeSigned:d})}catch(e){throw new o.p2(`\`twoStepSignatureCallback\` threw an error: ${e}`)}if(!(u instanceof ArrayBuffer||ee(u)||te(u)))throw new o.p2(`The resolved value from \`twoStepSignatureCallback\` should be a an \`ArrayBuffer\`, \`SignatureCallbackResponsePkcs7\`, or \`SignatureCallbackResponseRaw\`, but is of type \`${typeof u}\` instead.`);h=u}else{if(!e?.signingData||!e.signingData.privateKey)throw new o.p2("No `twoStepSignatureCallback` or `signingData.privateKey` was provided.");{const t={name:"RSASSA-PKCS1-v1_5",hash:{name:"SHA-256"},modulusLength:2048,extractable:!1,publicExponent:new Uint8Array([1,0,1])},n=await globalThis.crypto.subtle.importKey("pkcs8",function(e){const t=e.split("\n");let n="";for(let e=0;e<t.length;e++)t[e].trim().length>0&&t[e].indexOf("-BEGIN RSA PRIVATE KEY-")<0&&t[e].indexOf("-BEGIN PRIVATE KEY-")<0&&t[e].indexOf("-BEGIN RSA PUBLIC KEY-")<0&&t[e].indexOf("-BEGIN CERTIFICATE-")<0&&t[e].indexOf("-END RSA PRIVATE KEY-")<0&&t[e].indexOf("-END PRIVATE KEY-")<0&&t[e].indexOf("-END RSA PUBLIC KEY-")<0&&t[e].indexOf("-END CERTIFICATE-")<0&&(n+=t[e].trim());return c.DS.toUint8Array(n).buffer}(e.signingData.privateKey),t,!0,["sign"]);m=await globalThis.crypto.subtle.sign(t,n,d),h=m}}let p="",f=a.certificates||[];if(h instanceof ArrayBuffer)p=c.DS.fromUint8Array(new Uint8Array(h))||"";else if(ee(h)){const e=h;p=c.DS.fromUint8Array(new Uint8Array(e.pkcs7))||""}else if(te(h)){const e=h;p=c.DS.fromUint8Array(new Uint8Array(e.signedData))||"",f=e.certificates.map((e=>e instanceof ArrayBuffer?c.DS.fromUint8Array(new Uint8Array(e)):c.DS.encode(e)))}let g=null,y=[];if(e?.signingData?.ltv&&(h instanceof ArrayBuffer?y=await this.getRevocationResponses(f):(ee(h)||te(h))&&((0,o.kG)(null==h.ocspResponses||Array.isArray(h.ocspResponses)&&h.ocspResponses.every((e=>Q(e))),"The `ocspResponses` property of `signatureData` must be a array of `OCSPResponses`."),y=h.ocspResponses?.map((e=>({response_code:200,body:c.DS.fromUint8Array(new Uint8Array(e.body)),token:e.serialNumber})))??[],y.length||((0,o.ZK)("The `TwoStepSignatureCallback` didn't return certificate revocation responses; trying to fetch them online."),y=await this.getRevocationResponses(f)))),te(h)){const e=h;(0,o.kG)(null==e.timestampResponse||e.timestampResponse instanceof ArrayBuffer,"The `timestampResponse` property of `signatureData` must be an `ArrayBuffer`."),e.timestampResponse&&(g={response_code:200,body:c.DS.fromUint8Array(new Uint8Array(e.timestampResponse)),token:"1234"})}if(!g&&e?.signingData?.timestamp&&h instanceof ArrayBuffer){const t=c.DS.toUint8Array(p).buffer;g=await this.timestampData(t,e.signingData.timestamp)}const b=await this.client.sign(s,i,n,A.YA[a.signatureType],p,f,ee(h)?"pkcs7":te(h)?"raw":e?.signingData?.signatureContainer?e?.signingData?.signatureContainer:null,g,y);return e?.signingData?.ltv&&b.signature.certificateChainValidationStatus===Z.wk.ok_but_could_not_check_revocation&&(0,o.ZK)("Document signed, but couldn't add certificate revocation information so the signature may not be LTV-enabled."),await this.reloadDocument(),i}catch(e){throw await this.client.restoreToOriginalState(),e}}cancelRequests(){this._requestQueue.cancelAll()}async syncChanges(){}getDefaultGroup(){}isCollaborationPermissionsEnabled(){return!1}async clearAPStreamCache(){return this.client.clearAPStreamCache()}async setComparisonDocument(e,t){return this.client.setComparisonDocument(e,t)}async openComparisonDocument(e){return this._state=this._state.set("forceAnnotationsRender",!1),await this.client.closeDocument(),this._state=this._state.set("forceAnnotationsRender",!0),await this.client.openComparisonDocument(e)||this._state.documentResponse}async documentCompareAndOpen(e){return this.client.documentCompareAndOpen(e)}async persistOpenDocument(e){return this.client.persistOpenDocument(e)}async cleanupDocumentComparison(){return this.client.cleanupDocumentComparison()}async runPDFFormattingScripts(e,t){return this.client.runPDFFormattingScripts(e,t)}async runPDFFormattingScriptsFromWidgets(e,t,n){let a=[];if(this._isPDFJavaScriptEnabled){const{withAPStream:i,withoutAPStream:s}=e.reduce(((e,a)=>{if(a instanceof W.x_){const i=t?.get(a.formFieldName);if(i instanceof W.Yo)return e;n?.(a)?e.withAPStream.push(a.formFieldName):e.withoutAPStream.push(a.formFieldName)}return e}),{withAPStream:[],withoutAPStream:[]});let o=[];if(i.length&&!s.length)o=await this.runPDFFormattingScripts(i,!0);else if(!i.length&&s.length)o=await this.runPDFFormattingScripts(s,!1);else if(i.length&&s.length){const[e,t]=await Promise.all([this.runPDFFormattingScripts(i,!0),this.runPDFFormattingScripts(s,!1)]);o=e.concat(t)}a=(0,T.gE)(this._initialChanges,o)}return a}setFontSubstitutions(e){return this.client.setFontSubstitutions(e)}async contentEditorReload(){return(0,o.kG)(this.provider instanceof C,"Standalone can only use standalone annotation provider"),this.provider._state=this.provider._state.set("alreadyLoadedPages",(0,i.D5)()),this.reloadDocument()}getOCGs(){return this.client.getOCGs()}getOCGVisibilityState(){return this.client.getOCGVisibilityState()}setOCGVisibilityState(e){return this.client.setOCGVisibilityState(e)}updateButtonIcon(e,t,n){return this.client.updateButtonIcon((0,A.Hs)(e),t,n)}async timestampData(e,t){const{url:n,username:a="",password:i=""}=t,s=c.DS.fromUint8Array(new Uint8Array(e));try{const e=await this.client.getTimestampRequest(s,{url:n,username:a,password:i}),t={method:e.method,headers:{"Content-Type":e.contentType||"application/timestamp-query"},body:c.DS.toUint8Array(e.requestData).buffer};(e.username||e.password)&&(t.headers.Authorization=`Basic ${btoa(`${e.username}:${e.password}`)}`);try{const n=await fetch(e.url,t),a=await n.arrayBuffer();return{response_code:n.status,body:c.DS.fromUint8Array(new Uint8Array(a)),token:e.token}}catch(t){return{response_code:400,body:"",token:e.token,error_message:t.message}}}catch(e){return{response_code:500,body:"",token:"",error_message:e.message}}}}function se(e){return{baseUrl:e.baseUrl,baseCoreUrl:e.baseCoreUrl,baseProcessorEngineUrl:e.baseProcessorEngineUrl,licenseKey:e.licenseKey,document:e.document,disableWebAssemblyStreaming:!!e.disableWebAssemblyStreaming,enableAutomaticLinkExtraction:!!e.enableAutomaticLinkExtraction,overrideMemoryLimit:"number"==typeof e.overrideMemoryLimit?e.overrideMemoryLimit:null,documentHandle:"number"==typeof e.documentHandle?e.documentHandle:"0",trustedCAsCallback:"function"==typeof e.trustedCAsCallback?e.trustedCAsCallback:null,customFonts:Array.isArray(e.customFonts)?e.customFonts.filter((e=>e instanceof j.Z)):null,forceLegacySignaturesFeature:Boolean(e.forceLegacySignaturesFeature),appName:"string"==typeof e.appName?e.appName:null,productId:e.productId,processorEngine:e.processorEngine,dynamicFonts:e.dynamicFonts,fontSubstitutions:e.fontSubstitutions,inlineWorkers:e.inlineWorkers}}function oe(e){const{licenseKey:t,instantJSON:n,XFDF:a,disableWebAssemblyStreaming:i,disableIndexedDBCaching:s,enableAutomaticLinkExtraction:r,overrideMemoryLimit:l,standaloneInstancesPoolSize:c,trustedCAsCallback:d,baseUrl:u,baseCoreUrl:m,baseProcessorEngineUrl:h,customFonts:p,isSharePoint:f,isSalesforce:g,dynamicFonts:y,inlineWorkers:b}=e;if((0,o.kG)("string"==typeof u,"`baseUrl` is mandatory and must be a valid URL, e.g. `https://example.com/"),(0,G.Pn)(u),(0,o.kG)(!m||"string"==typeof m,"`baseCoreUrl` must be a valid URL if set, e.g. `https://example.com/"),m&&(0,G.rH)(m),(0,o.kG)(!h||"string"==typeof h,"`baseProcessorEngineUrl` must be a valid URL if set, e.g. `https://example.com/"),h&&(0,G.qH)(h),(0,o.kG)(null==t||"string"==typeof t,"licenseKey must be a string value if provided. Please obtain yours from https://customers.pspdfkit.com."),"string"==typeof t&&(0,o.kG)(!t.startsWith("TRIAL-"),"You're using the npm key instead of the license key. This key is used to download the PSPDFKit for Web package via the node package manager.\n\nLeave out the license key to activate as a trial."),(0,o.kG)(void 0===a||"string"==typeof a,"XFDF must be a string"),n&&((0,o.Ou)(n),(0,o.kG)(void 0===a,"Cannot import from both instantJSON and XFDF")),(0,o.kG)(void 0===i||"boolean"==typeof i,"disableWebAssemblyStreaming must be a boolean"),(0,o.kG)(void 0===r||"boolean"==typeof r,"enableAutomaticLinkExtraction must be a boolean"),(0,o.kG)(void 0===l||"number"==typeof l,"overrideMemoryLimit must be a number"),(0,o.kG)(void 0===c||"number"==typeof c&&c>=0,"standaloneInstancesPoolSize must be a non-negative number"),(0,o.kG)(void 0===d||"function"==typeof d,"trustedCAsCallback must be a function"),(0,o.kG)(void 0===p||Array.isArray(p)&&p.every((e=>e instanceof j.Z)),"customFonts must be an array of PSPDFKit.Font instances"),(0,o.kG)(void 0===p||p.every((e=>e.callback)),"All PSPDFKit.Font instances specified on customFonts must have its callback property defined"),void 0!==s&&(0,o.a1)("disableIndexedDbCaching has been deprecated and it no longer has effect. It will be removed in a later version.\nBrowsers dropped IndexedDB serialization of Wasm modules in favor of regular HTTP caching."),(f||g)&&(0,o.a1)("isSharePoint and isSalesforce configuration properties are deprecated and will be removed in the next major release. Please use the new Configuration#productId property instead. For more information, please check the migration guide."),(0,o.kG)(!(f&&g),"You cannot enable both SharePoint and Salesforce integrations at the same time. Please set either isSharePoint or isSalesforce to true, but not both."),"string"==typeof y)try{new URL(y)}catch(e){throw new o.p2("dynamicFonts must be a valid URL to a JSON file containing the data for fonts to be dynamically loaded.")}(0,o.kG)(void 0===b||"boolean"==typeof b,"inlineWorkers must be a boolean")}async function re(e){const t=new WeakMap,n={};return{processedOperations:await Promise.all(e.map((async(e,a)=>{if("importDocument"===e.type){const{document:i}=e;return(0,o.kG)(i instanceof File||i instanceof Blob,"Wrong `importDocument` operation `document` value: it must be a File or a Blob"),(0,E.M)(t,n,i,e,a,"document")}if("applyInstantJson"===e.type){const i=e.instantJson;(0,o.kG)("object"==typeof i&&null!==i,"Wrong `applyInstantJson` operation `instantJson` value: it must be an object");const s=JSON.stringify(i),r=new Blob([s],{type:"application/json"});return(0,E.M)(t,n,r,e,a,"dataFilePath")}if("applyXfdf"===e.type){const i=e.xfdf;(0,o.kG)("string"==typeof i,"Wrong `applyXfdf` operation `xfdf` value: it must be a string");const s=new Blob([i],{type:"application/vnd.adobe.xfdf"});return(0,E.M)(t,n,s,e,a,"dataFilePath")}return e}))),operationsDocuments:n}}},67055:(e,t,n)=>{n.d(t,{i:()=>r});var a=n(35369);class i extends(a.WV({id:"",attachmentId:"",description:null,fileName:null,fileSize:null,updatedAt:null})){}var s=n(34923);function o(e,t){return t}function r(e,t){let n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];return o(0,n)?new i({id:(0,s.C)(),description:t.fileDescription,attachmentId:e,fileName:t.fileName||null,fileSize:t.fileSize||null,updatedAt:t.modificationDate?new Date(t.modificationDate):null}):new i({id:e,description:t.description,attachmentId:t.fileAttachmentId,fileName:t.fileName||null,fileSize:t.fileSize||null,updatedAt:new Date(t.updatedAt)||null})}},7407:(e,t,n)=>{n.d(t,{a:()=>l,i:()=>c});var a=n(15359),i=n(35369),s=n(96029),o=n(74751),r=n(45249);function l(e){return{type:"pspdfkit/outline-element",children:e.children&&e.children.map((e=>l(e))).toJS(),title:e.title,color:e.color&&(0,o.C)(e.color),isBold:e.isBold,isItalic:e.isItalic,isExpanded:e.isExpanded,action:e.action&&(0,s.vP)(e.action)}}function c(e){let t,n;(0,a.kG)("pspdfkit/outline-element"===e.type,"invalid outline element type."),(0,a.kG)(null==e.children||Array.isArray(e.children),"children must be an Array<OutlineElement>."),(0,a.kG)("string"==typeof e.title,"title must be a string."),(0,a.kG)(null==e.isBold||"boolean"==typeof e.isBold,"isBold must be a boolean."),(0,a.kG)(null==e.isItalic||"boolean"==typeof e.isItalic,"isItalic must be a boolean."),(0,a.kG)(null==e.isExpanded||"boolean"==typeof e.isExpanded,"isExpanded must be a boolean.");try{t=e.action&&(0,s.lk)(e.action)}catch(t){(0,a.ZK)(`PDF Action not supported ${JSON.stringify(e.action)})`)}try{n=e.color&&(0,o.b)(e.color)}catch(t){(0,a.ZK)(`Invalid color:\n\n${e.color}`)}const l={title:e.title,color:n,isBold:!0===e.isBold,isItalic:!0===e.isItalic,isExpanded:!0===e.isExpanded,action:t,children:(0,i.aV)()};return e.children&&e.children.length>0&&(l.children=(0,i.aV)(e.children.map(c))),new r.sT(l)}},88265:(e,t,n)=>{function a(e,t,n,a,i,s){let o;return e.has(n)?o=e.get(n):(o=i.toString(),t[o]=n,e.set(n,o)),{...a,[s]:o}}n.d(t,{M:()=>a})},84254:(e,t,n)=>{n.d(t,{E:()=>r});var a=n(35369),i=n(15359),s=n(98492),o=n(68804);function r(e){return(0,i.kG)(Array.isArray(e),"Wrong `json` field"),(0,a.aV)(e.map((e=>((0,i.kG)("number"==typeof e.pageIndex,"Wrong `pageIndex` field"),(0,i.kG)("string"==typeof e.previewText,"Wrong `previewText` field"),(0,i.kG)(Array.isArray(e.rangeInPreview),"Wrong `rangeInPreview` field"),(0,i.kG)(Array.isArray(e.rectsOnPage),"Wrong `rectsOnPage` field"),new o.Z({pageIndex:e.pageIndex,previewText:e.previewText,locationInPreview:e.rangeInPreview[0],lengthInPreview:e.rangeInPreview[1],rectsOnPage:(0,a.aV)(e.rectsOnPage).map((e=>(0,s.k)(e))),isAnnotation:!!e.isAnnotation,annotationRect:e.annotationRect?(0,s.k)(e.annotationRect):null})))).filter(Boolean))}}}]);